/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export.datatext;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.export.datatext.OrbadaExportDataTextPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.variant.Variant;

public class ExportToDataTextDialog
extends JDialog {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportDataTextPlugin.class);
    private ISettings config;
    private int modalResult = 0;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmOk;
    private JComboBox comboCharset;
    private JLabel jLabel7;

    public ExportToDataTextDialog(ISettings config) {
        super(SwingUtil.getRootFrame());
        this.config = config;
        this.initComponents();
        this.init();
    }

    public static boolean showDialog(ISettings config) {
        ExportToDataTextDialog dialog = new ExportToDataTextDialog(config);
        dialog.setVisible(true);
        return dialog.modalResult == 1;
    }

    private void init() {
        SwingUtil.centerWithinScreen((Window)this);
        for (Charset charset : Charset.availableCharsets().values()) {
            this.comboCharset.addItem(charset.displayName());
        }
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.configToDialog();
    }

    private void configToDialog() {
        try {
            this.comboCharset.setSelectedItem(this.config.getValue("charset", Charset.defaultCharset().displayName()));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void dialogToConfig() {
        this.config.setValue("charset", new Variant(this.comboCharset.getSelectedItem().toString()));
        this.config.store();
    }

    private boolean selectFile() {
        File lastFile = null;
        try {
            if (!this.config.getValue("file-name").getString().equals("")) {
                lastFile = new File(this.config.getValue("file-name").getString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        lastFile = FileUtil.selectFileToSave((Component)this, null, null, (File)lastFile, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("data-text-file-filter"), new String[]{".dt"})});
        if (lastFile != null) {
            this.config.setValue("file-name", new Variant((Object)lastFile.getAbsoluteFile()));
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel7 = new JLabel();
        this.comboCharset = new JComboBox();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToDataTextDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToDataTextDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("ExportToDataTextDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("charset-dd"));
        this.comboCharset.setEditable(true);
        this.comboCharset.setFont(new Font("Courier New", 0, 12));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7, -2, 117, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboCharset, 0, 255, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2).addGap(10, 10, 10)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboCharset, -2, 22, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.buttonCancel, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        if (this.selectFile()) {
            this.modalResult = 1;
            this.dialogToConfig();
            this.dispose();
        }
    }
}

