/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.ref.SoftReference;

class BufferCache {
    SoftReference[] buffers;
    int top = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_08:37:51_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    BufferCache(int n2) {
        this.buffers = new SoftReference[n2];
    }

    void resize(int n2) {
        SoftReference[] softReferenceArray = new SoftReference[n2];
        System.arraycopy(this.buffers, Math.max(0, this.top - softReferenceArray.length), softReferenceArray, 0, Math.min(this.top, softReferenceArray.length));
        this.buffers = softReferenceArray;
        this.top = Math.min(this.top, this.buffers.length);
    }

    void clear() {
        while (this.top > 0) {
            this.buffers[--this.top] = null;
        }
    }

    void put(Object object) {
        if (this.top < this.buffers.length) {
            this.buffers[this.top++] = new SoftReference<Object>(object);
        } else {
            int n2 = this.top;
            while (n2 > 0) {
                if (this.buffers[--n2].get() != null) continue;
                this.buffers[n2] = new SoftReference<Object>(object);
                return;
            }
        }
    }

    Object get() {
        while (this.top > 0) {
            Object t = this.buffers[--this.top].get();
            this.buffers[this.top] = null;
            if (t == null) continue;
            return t;
        }
        return null;
    }
}

