/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleStatementCacheEntry;
import oracle.jdbc.internal.OracleConnection;

class LRUStatementCache {
    private int cacheSize;
    private int numElements;
    private OracleStatementCacheEntry applicationCacheStart;
    private OracleStatementCacheEntry applicationCacheEnd;
    private OracleStatementCacheEntry implicitCacheStart;
    private OracleStatementCacheEntry explicitCacheStart;
    boolean implicitCacheEnabled;
    boolean explicitCacheEnabled;
    private boolean debug = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_08:37:52_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    protected LRUStatementCache(int n2) throws SQLException {
        if (n2 < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 123);
        }
        this.cacheSize = n2;
        this.numElements = 0;
        this.implicitCacheStart = null;
        this.explicitCacheStart = null;
        this.implicitCacheEnabled = false;
        this.explicitCacheEnabled = false;
    }

    protected void resize(int n2) throws SQLException {
        if (n2 < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 123);
        }
        if (n2 >= this.cacheSize || n2 >= this.numElements) {
            this.cacheSize = n2;
        } else {
            OracleStatementCacheEntry oracleStatementCacheEntry = this.applicationCacheEnd;
            while (this.numElements > n2) {
                this.purgeCacheEntry(oracleStatementCacheEntry);
                oracleStatementCacheEntry = oracleStatementCacheEntry.applicationPrev;
            }
            this.cacheSize = n2;
        }
    }

    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        if (!bl) {
            this.purgeImplicitCache();
        }
        this.implicitCacheEnabled = bl;
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        boolean bl = this.cacheSize == 0 ? false : this.implicitCacheEnabled;
        return bl;
    }

    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        if (!bl) {
            this.purgeExplicitCache();
        }
        this.explicitCacheEnabled = bl;
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        boolean bl = this.cacheSize == 0 ? false : this.explicitCacheEnabled;
        return bl;
    }

    protected void addToImplicitCache(OraclePreparedStatement oraclePreparedStatement, String string, int n2, int n3) throws SQLException {
        if (!this.implicitCacheEnabled || this.cacheSize == 0 || oraclePreparedStatement.cacheState == 2) {
            return;
        }
        if (this.numElements == this.cacheSize) {
            this.purgeCacheEntry(this.applicationCacheEnd);
        }
        oraclePreparedStatement.enterImplicitCache();
        OracleStatementCacheEntry oracleStatementCacheEntry = new OracleStatementCacheEntry();
        oracleStatementCacheEntry.statement = oraclePreparedStatement;
        oracleStatementCacheEntry.onImplicit = true;
        oracleStatementCacheEntry.sql = string;
        oracleStatementCacheEntry.statementType = n2;
        oracleStatementCacheEntry.scrollType = n3;
        oracleStatementCacheEntry.applicationNext = this.applicationCacheStart;
        oracleStatementCacheEntry.applicationPrev = null;
        if (this.applicationCacheStart != null) {
            this.applicationCacheStart.applicationPrev = oracleStatementCacheEntry;
        }
        this.applicationCacheStart = oracleStatementCacheEntry;
        oracleStatementCacheEntry.implicitNext = this.implicitCacheStart;
        oracleStatementCacheEntry.implicitPrev = null;
        if (this.implicitCacheStart != null) {
            this.implicitCacheStart.implicitPrev = oracleStatementCacheEntry;
        }
        this.implicitCacheStart = oracleStatementCacheEntry;
        if (this.applicationCacheEnd == null) {
            this.applicationCacheEnd = oracleStatementCacheEntry;
        }
        ++this.numElements;
    }

    protected void addToExplicitCache(OraclePreparedStatement oraclePreparedStatement, String string) throws SQLException {
        if (!this.explicitCacheEnabled || this.cacheSize == 0 || oraclePreparedStatement.cacheState == 2) {
            return;
        }
        if (this.numElements == this.cacheSize) {
            this.purgeCacheEntry(this.applicationCacheEnd);
        }
        oraclePreparedStatement.enterExplicitCache();
        OracleStatementCacheEntry oracleStatementCacheEntry = new OracleStatementCacheEntry();
        oracleStatementCacheEntry.statement = oraclePreparedStatement;
        oracleStatementCacheEntry.sql = string;
        oracleStatementCacheEntry.onImplicit = false;
        oracleStatementCacheEntry.applicationNext = this.applicationCacheStart;
        oracleStatementCacheEntry.applicationPrev = null;
        if (this.applicationCacheStart != null) {
            this.applicationCacheStart.applicationPrev = oracleStatementCacheEntry;
        }
        this.applicationCacheStart = oracleStatementCacheEntry;
        oracleStatementCacheEntry.explicitNext = this.explicitCacheStart;
        oracleStatementCacheEntry.explicitPrev = null;
        if (this.explicitCacheStart != null) {
            this.explicitCacheStart.explicitPrev = oracleStatementCacheEntry;
        }
        this.explicitCacheStart = oracleStatementCacheEntry;
        if (this.applicationCacheEnd == null) {
            this.applicationCacheEnd = oracleStatementCacheEntry;
        }
        ++this.numElements;
    }

    protected OracleStatement searchImplicitCache(String string, int n2, int n3) throws SQLException {
        if (!this.implicitCacheEnabled) {
            return null;
        }
        OracleStatementCacheEntry oracleStatementCacheEntry = null;
        oracleStatementCacheEntry = this.implicitCacheStart;
        while (!(oracleStatementCacheEntry == null || oracleStatementCacheEntry.statementType == n2 && oracleStatementCacheEntry.scrollType == n3 && oracleStatementCacheEntry.sql.equals(string))) {
            oracleStatementCacheEntry = oracleStatementCacheEntry.implicitNext;
        }
        if (oracleStatementCacheEntry != null) {
            if (oracleStatementCacheEntry.applicationPrev != null) {
                oracleStatementCacheEntry.applicationPrev.applicationNext = oracleStatementCacheEntry.applicationNext;
            }
            if (oracleStatementCacheEntry.applicationNext != null) {
                oracleStatementCacheEntry.applicationNext.applicationPrev = oracleStatementCacheEntry.applicationPrev;
            }
            if (this.applicationCacheStart == oracleStatementCacheEntry) {
                this.applicationCacheStart = oracleStatementCacheEntry.applicationNext;
            }
            if (this.applicationCacheEnd == oracleStatementCacheEntry) {
                this.applicationCacheEnd = oracleStatementCacheEntry.applicationPrev;
            }
            if (oracleStatementCacheEntry.implicitPrev != null) {
                oracleStatementCacheEntry.implicitPrev.implicitNext = oracleStatementCacheEntry.implicitNext;
            }
            if (oracleStatementCacheEntry.implicitNext != null) {
                oracleStatementCacheEntry.implicitNext.implicitPrev = oracleStatementCacheEntry.implicitPrev;
            }
            if (this.implicitCacheStart == oracleStatementCacheEntry) {
                this.implicitCacheStart = oracleStatementCacheEntry.implicitNext;
            }
            --this.numElements;
            oracleStatementCacheEntry.statement.exitImplicitCacheToActive();
            return oracleStatementCacheEntry.statement;
        }
        return null;
    }

    protected OracleStatement searchExplicitCache(String string) throws SQLException {
        if (!this.explicitCacheEnabled) {
            return null;
        }
        OracleStatementCacheEntry oracleStatementCacheEntry = null;
        oracleStatementCacheEntry = this.explicitCacheStart;
        while (oracleStatementCacheEntry != null && !oracleStatementCacheEntry.sql.equals(string)) {
            oracleStatementCacheEntry = oracleStatementCacheEntry.explicitNext;
        }
        if (oracleStatementCacheEntry != null) {
            if (oracleStatementCacheEntry.applicationPrev != null) {
                oracleStatementCacheEntry.applicationPrev.applicationNext = oracleStatementCacheEntry.applicationNext;
            }
            if (oracleStatementCacheEntry.applicationNext != null) {
                oracleStatementCacheEntry.applicationNext.applicationPrev = oracleStatementCacheEntry.applicationPrev;
            }
            if (this.applicationCacheStart == oracleStatementCacheEntry) {
                this.applicationCacheStart = oracleStatementCacheEntry.applicationNext;
            }
            if (this.applicationCacheEnd == oracleStatementCacheEntry) {
                this.applicationCacheEnd = oracleStatementCacheEntry.applicationPrev;
            }
            if (oracleStatementCacheEntry.explicitPrev != null) {
                oracleStatementCacheEntry.explicitPrev.explicitNext = oracleStatementCacheEntry.explicitNext;
            }
            if (oracleStatementCacheEntry.explicitNext != null) {
                oracleStatementCacheEntry.explicitNext.explicitPrev = oracleStatementCacheEntry.explicitPrev;
            }
            if (this.explicitCacheStart == oracleStatementCacheEntry) {
                this.explicitCacheStart = oracleStatementCacheEntry.explicitNext;
            }
            --this.numElements;
            oracleStatementCacheEntry.statement.exitExplicitCacheToActive();
            return oracleStatementCacheEntry.statement;
        }
        return null;
    }

    protected void purgeImplicitCache() throws SQLException {
        OracleStatementCacheEntry oracleStatementCacheEntry = this.implicitCacheStart;
        while (oracleStatementCacheEntry != null) {
            this.purgeCacheEntry(oracleStatementCacheEntry);
            oracleStatementCacheEntry = oracleStatementCacheEntry.implicitNext;
        }
        this.implicitCacheStart = null;
    }

    protected void purgeExplicitCache() throws SQLException {
        OracleStatementCacheEntry oracleStatementCacheEntry = this.explicitCacheStart;
        while (oracleStatementCacheEntry != null) {
            this.purgeCacheEntry(oracleStatementCacheEntry);
            oracleStatementCacheEntry = oracleStatementCacheEntry.explicitNext;
        }
        this.explicitCacheStart = null;
    }

    private void purgeCacheEntry(OracleStatementCacheEntry oracleStatementCacheEntry) throws SQLException {
        if (oracleStatementCacheEntry.applicationNext != null) {
            oracleStatementCacheEntry.applicationNext.applicationPrev = oracleStatementCacheEntry.applicationPrev;
        }
        if (oracleStatementCacheEntry.applicationPrev != null) {
            oracleStatementCacheEntry.applicationPrev.applicationNext = oracleStatementCacheEntry.applicationNext;
        }
        if (this.applicationCacheStart == oracleStatementCacheEntry) {
            this.applicationCacheStart = oracleStatementCacheEntry.applicationNext;
        }
        if (this.applicationCacheEnd == oracleStatementCacheEntry) {
            this.applicationCacheEnd = oracleStatementCacheEntry.applicationPrev;
        }
        if (oracleStatementCacheEntry.onImplicit) {
            if (oracleStatementCacheEntry.implicitNext != null) {
                oracleStatementCacheEntry.implicitNext.implicitPrev = oracleStatementCacheEntry.implicitPrev;
            }
            if (oracleStatementCacheEntry.implicitPrev != null) {
                oracleStatementCacheEntry.implicitPrev.implicitNext = oracleStatementCacheEntry.implicitNext;
            }
            if (this.implicitCacheStart == oracleStatementCacheEntry) {
                this.implicitCacheStart = oracleStatementCacheEntry.implicitNext;
            }
        } else {
            if (oracleStatementCacheEntry.explicitNext != null) {
                oracleStatementCacheEntry.explicitNext.explicitPrev = oracleStatementCacheEntry.explicitPrev;
            }
            if (oracleStatementCacheEntry.explicitPrev != null) {
                oracleStatementCacheEntry.explicitPrev.explicitNext = oracleStatementCacheEntry.explicitNext;
            }
            if (this.explicitCacheStart == oracleStatementCacheEntry) {
                this.explicitCacheStart = oracleStatementCacheEntry.explicitNext;
            }
        }
        --this.numElements;
        if (oracleStatementCacheEntry.onImplicit) {
            oracleStatementCacheEntry.statement.exitImplicitCacheToClose();
        } else {
            oracleStatementCacheEntry.statement.exitExplicitCacheToClose();
        }
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void printCache(String string) throws SQLException {
        System.out.println("*** Start of Statement Cache Dump (" + string + ") ***");
        System.out.println("cache size: " + this.cacheSize + " num elements: " + this.numElements + " implicit enabled: " + this.implicitCacheEnabled + " explicit enabled: " + this.explicitCacheEnabled);
        System.out.println("applicationStart: " + this.applicationCacheStart + "  applicationEnd: " + this.applicationCacheEnd);
        OracleStatementCacheEntry oracleStatementCacheEntry = this.applicationCacheStart;
        while (oracleStatementCacheEntry != null) {
            oracleStatementCacheEntry.print();
            oracleStatementCacheEntry = oracleStatementCacheEntry.applicationNext;
        }
        System.out.println("implicitStart: " + this.implicitCacheStart);
        oracleStatementCacheEntry = this.implicitCacheStart;
        while (oracleStatementCacheEntry != null) {
            oracleStatementCacheEntry.print();
            oracleStatementCacheEntry = oracleStatementCacheEntry.implicitNext;
        }
        System.out.println("explicitStart: " + this.explicitCacheStart);
        oracleStatementCacheEntry = this.explicitCacheStart;
        while (oracleStatementCacheEntry != null) {
            oracleStatementCacheEntry.print();
            oracleStatementCacheEntry = oracleStatementCacheEntry.explicitNext;
        }
        System.out.println("*** End of Statement Cache Dump (" + string + ") ***");
    }

    public void close() throws SQLException {
        OracleStatementCacheEntry oracleStatementCacheEntry = this.applicationCacheStart;
        while (oracleStatementCacheEntry != null) {
            if (oracleStatementCacheEntry.onImplicit) {
                oracleStatementCacheEntry.statement.exitImplicitCacheToClose();
            } else {
                oracleStatementCacheEntry.statement.exitExplicitCacheToClose();
            }
            oracleStatementCacheEntry = oracleStatementCacheEntry.applicationNext;
        }
        this.applicationCacheStart = null;
        this.applicationCacheEnd = null;
        this.implicitCacheStart = null;
        this.explicitCacheStart = null;
        this.numElements = 0;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

