/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import oracle.jdbc.OracleConnectionWrapper;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ClientDataSupport;

public abstract class OracleConnection
extends OracleConnectionWrapper
implements oracle.jdbc.internal.OracleConnection,
ClientDataSupport {
    static int DEFAULT_ROW_PREFETCH = 10;
    static final String svptPrefix = "ORACLE_SVPT_";
    static final int BINARYSTREAM = 0;
    static final int ASCIISTREAM = 1;
    static final int UNICODESTREAM = 2;
    static final int EOJ_NON = 0;
    static final int EOJ_B_TO_A = 1;
    static final int EOJ_B_TO_U = 2;
    static final int EOJ_A_TO_U = 3;
    static final int EOJ_8_TO_A = 4;
    static final int EOJ_8_TO_U = 5;
    static final int EOJ_U_TO_A = 6;
    static final int ASCII_CHARSET = 0;
    static final int NLS_CHARSET = 1;
    static final int CHAR_TO_ASCII = 0;
    static final int CHAR_TO_UNICODE = 1;
    static final int RAW_TO_ASCII = 2;
    static final int RAW_TO_UNICODE = 3;
    static final int UNICODE_TO_CHAR = 4;
    static final int ASCII_TO_CHAR = 5;
    static final int NONE = 6;
    static final int JAVACHAR_TO_CHAR = 7;
    static final int RAW_TO_JAVACHAR = 8;
    static final int CHAR_TO_JAVACHAR = 9;
    static final int JAVACHAR_TO_ASCII = 10;
    static final int JAVACHAR_TO_UNICODE = 11;
    static final List<String> RESERVED_NAMESPACES = Arrays.asList("SYS");
    static final Pattern SUPPORTED_NAMESPACE_PATTERN = Pattern.compile("CLIENTCONTEXT");
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_08:37:55_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    static boolean containsKey(Map map, Object object) {
        return map.get(object) != null;
    }

    @Override
    public abstract Object getClientData(Object var1);

    @Override
    public abstract Object setClientData(Object var1, Object var2);

    @Override
    public abstract Object removeClientData(Object var1);

    public abstract void setClientIdentifier(String var1) throws SQLException;

    public abstract void clearClientIdentifier(String var1) throws SQLException;

    @Override
    public boolean isValid(int n2) throws SQLException {
        return this.pingDatabase(n2) == 0;
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        this.setClientInfoInternal(string, string2, null);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        Properties properties2 = (Properties)properties.clone();
        for (String string : properties.stringPropertyNames()) {
            String string2 = properties.getProperty(string);
            this.setClientInfoInternal(string, string2, properties2);
            properties2.remove(string);
        }
    }

    void setClientInfoInternal(String string, String string2, Properties properties) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
        if (properties != null) {
            for (String string3 : properties.stringPropertyNames()) {
                hashMap.put(string3, ClientInfoStatus.REASON_UNKNOWN);
            }
        }
        DatabaseError.throwSQLClientInfoException(253, hashMap, null);
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 253, string);
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return new Properties();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isInterface()) {
            return clazz.isInstance(this);
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 177);
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 177);
        return null;
    }

    @Override
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return this;
    }
}

