/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleTypeUPT
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -1994358478872378695L;
    static final byte KOPU_UPT_ADT = -6;
    static final byte KOPU_UPT_COLL = -5;
    static final byte KOPU_UPT_REFCUR = 102;
    static final byte KOTTCOPQ = 58;
    byte uptCode = 0;
    OracleNamedType realType = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_08:37:47_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    protected OracleTypeUPT() {
    }

    public OracleTypeUPT(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, (Connection)oracleConnection);
    }

    public OracleTypeUPT(OracleTypeADT oracleTypeADT, int n2, OracleConnection oracleConnection) throws SQLException {
        super(oracleTypeADT, n2, (Connection)oracleConnection);
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            return this.realType.toDatum(object, oracleConnection);
        }
        return null;
    }

    @Override
    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        if (object != null) {
            return this.realType.toDatumArray(object, oracleConnection, l2, n2);
        }
        return null;
    }

    @Override
    public int getTypeCode() throws SQLException {
        switch (this.uptCode) {
            case -6: {
                return this.realType.getTypeCode();
            }
            case -5: {
                return 2003;
            }
            case 58: {
                return 2007;
            }
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid type code");
        return 0;
    }

    @Override
    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        return false;
    }

    @Override
    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    @Override
    public boolean isObjectType() {
        return false;
    }

    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        long l2 = tDSReader.readLong();
        this.uptCode = tDSReader.readByte();
        tDSReader.addNormalPatch(l2, this.uptCode, this);
    }

    @Override
    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        int n2 = 0;
        if (datum == null) {
            n2 += pickleContext.writeElementNull();
        } else {
            int n3 = pickleContext.offset();
            n2 += pickleContext.writeLength(PickleContext.KOPI20_LN_MAXV + 1);
            int n4 = 0;
            if (this.uptCode == -6 && !((OracleTypeADT)this.realType).isFinalType()) {
                if (datum instanceof STRUCT) {
                    n4 = ((STRUCT)datum).getDescriptor().getOracleTypeADT().pickle81(pickleContext, datum);
                } else {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "invalid upt state");
                }
            } else {
                n4 = this.realType.pickle81(pickleContext, datum);
            }
            n2 += n4;
            pickleContext.patchImageLen(n3, n4);
        }
        return n2;
    }

    @Override
    protected Object unpickle81rec(PickleContext pickleContext, int n2, Map map) throws SQLException {
        byte by = pickleContext.readByte();
        if (PickleContext.isElementNull(by)) {
            return null;
        }
        if (n2 == 9) {
            pickleContext.skipBytes(pickleContext.readRestOfLength(by));
            return null;
        }
        pickleContext.skipRestOfLength(by);
        return this.unpickle81UPT(pickleContext, n2, map);
    }

    @Override
    protected Object unpickle81rec(PickleContext pickleContext, byte by, int n2, Map map) throws SQLException {
        long l2 = pickleContext.readRestOfLength(by);
        if (n2 == 9) {
            pickleContext.skipBytes((int)l2);
            return null;
        }
        return this.unpickle81UPT(pickleContext, n2, map);
    }

    private Object unpickle81UPT(PickleContext pickleContext, int n2, Map map) throws SQLException {
        switch (this.uptCode) {
            case -6: {
                switch (n2) {
                    case 1: {
                        return ((OracleTypeADT)this.realType).unpickle81(pickleContext, null, 3, n2, map);
                    }
                    case 2: {
                        STRUCT sTRUCT = ((OracleTypeADT)this.realType).unpickle81(pickleContext, null, 1, n2, map);
                        return sTRUCT == null ? sTRUCT : sTRUCT.toJdbc(map);
                    }
                    case 9: {
                        return ((OracleTypeADT)this.realType).unpickle81(pickleContext, null, 9, 1, map);
                    }
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
                break;
            }
            case -5: {
                return ((OracleTypeCOLLECTION)this.realType).unpickle81(pickleContext, (ARRAY)null, n2 == 9 ? n2 : 3, n2, map);
            }
            case 58: {
                switch (n2) {
                    case 1: 
                    case 9: {
                        return ((OracleTypeOPAQUE)this.realType).unpickle81(pickleContext, null, n2, map);
                    }
                    case 2: {
                        OPAQUE oPAQUE = ((OracleTypeOPAQUE)this.realType).unpickle81(pickleContext, null, n2, map);
                        return oPAQUE == null ? oPAQUE : oPAQUE.toJdbc(map);
                    }
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
            }
            default: {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unrecognized UPT code");
            }
        }
        return null;
    }

    @Override
    protected Datum unpickle81datumAsNull(PickleContext pickleContext, byte by, byte by2) throws SQLException {
        return null;
    }

    @Override
    StructDescriptor createStructDescriptor() throws SQLException {
        StructDescriptor structDescriptor = null;
        structDescriptor = this.sqlName == null ? new StructDescriptor((OracleTypeADT)this.realType, (Connection)this.connection) : StructDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        return structDescriptor;
    }

    ArrayDescriptor createArrayDescriptor() throws SQLException {
        ArrayDescriptor arrayDescriptor = null;
        arrayDescriptor = this.sqlName == null ? new ArrayDescriptor((OracleTypeCOLLECTION)this.realType, (Connection)this.connection) : ArrayDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        return arrayDescriptor;
    }

    public OracleType getRealType() throws SQLException {
        return this.realType;
    }

    @Override
    public int getNumAttrs() throws SQLException {
        return ((OracleTypeADT)this.realType).getNumAttrs();
    }

    @Override
    public OracleType getAttrTypeAt(int n2) throws SQLException {
        return ((OracleTypeADT)this.realType).getAttrTypeAt(n2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.uptCode);
        objectOutputStream.writeObject(this.realType);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.uptCode = objectInputStream.readByte();
        this.realType = (OracleNamedType)objectInputStream.readObject();
    }

    @Override
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
        this.realType.setConnection(oracleConnection);
    }

    @Override
    public void initChildNamesRecursively(Map map) throws SQLException {
        if (this.realType != null) {
            this.realType.setSqlName(this.sqlName);
            this.realType.initChildNamesRecursively(map);
        }
    }

    @Override
    public void initMetadataRecursively() throws SQLException {
        this.initMetadata(this.connection);
        if (this.realType != null) {
            this.realType.initMetadataRecursively();
        }
    }

    @Override
    public void cacheDescriptor() throws SQLException {
    }

    @Override
    public void printXML(PrintWriter printWriter, int n2, boolean bl) throws SQLException {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print("  ");
        }
        printWriter.println("<OracleTypeUPT sqlName=\"" + this.sqlName + "\" " + " toid=\"" + this.toid + "\" " + ">");
        if (this.realType != null) {
            this.realType.printXML(printWriter, n2 + 1, bl);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print("  ");
        }
        printWriter.println("</OracleTypeUPT>");
    }

    @Override
    public void printXML(PrintWriter printWriter, int n2) throws SQLException {
        this.printXML(printWriter, n2, false);
    }
}

