/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleCachedRowSetWriter;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleSerialBlob;
import oracle.jdbc.rowset.OracleSerialClob;
import oracle.jdbc.rowset.OracleSqlForRowSet;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.TIMESTAMP;

public class OracleCachedRowSet
extends OracleRowSet
implements RowSet,
RowSetInternal,
Serializable,
Cloneable,
CachedRowSet {
    private SQLWarning sqlWarning;
    private RowSetWarning rowsetWarning;
    protected int presentRow = 0;
    private int currentPage;
    private boolean isPopulateDone;
    private boolean previousColumnWasNull = false;
    private OracleRow insertRow;
    private int insertRowPosition;
    private boolean insertRowFlag = false;
    private int updateRowPosition;
    private boolean updateRowFlag = false;
    protected ResultSetMetaData rowsetMetaData;
    private transient ResultSet resultSet;
    private transient Connection connection;
    private transient boolean isConnectionStayingOpenForTxnControl = false;
    private transient OracleSqlForRowSet osql = null;
    protected Vector rows;
    private Vector param = new Vector();
    private String[] metaData;
    protected int colCount;
    protected int rowCount;
    private RowSetReader reader;
    private RowSetWriter writer;
    private int[] keyColumns;
    private int pageSize;
    private SyncProvider syncProvider;
    private static final String DEFAULT_SYNCPROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";
    private String tableName;
    private boolean driverManagerInitialized = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_08:38:12_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleCachedRowSet() throws SQLException {
        this.rows = new Vector();
        this.sqlWarning = new SQLWarning();
        try {
            this.syncProvider = SyncFactory.getInstance(DEFAULT_SYNCPROVIDER);
        }
        catch (SyncFactoryException syncFactoryException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 304);
        }
        this.setReader(new OracleCachedRowSetReader());
        this.setWriter(new OracleCachedRowSetWriter());
        this.currentPage = 0;
        this.pageSize = 0;
        this.isPopulateDone = false;
        this.keyColumns = null;
        this.tableName = null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnectionInternal();
    }

    Connection getConnectionInternal() throws SQLException {
        block13: {
            if (this.connection == null || this.connection.isClosed()) {
                String string = this.getUsername();
                String string2 = this.getPassword();
                if (this.getDataSourceName() != null) {
                    try {
                        Object object;
                        InitialContext initialContext = null;
                        try {
                            object = System.getProperties();
                            initialContext = new InitialContext((Hashtable<?, ?>)object);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                        if (initialContext == null) {
                            initialContext = new InitialContext();
                        }
                        object = (DataSource)initialContext.lookup(this.getDataSourceName());
                        if (this.username == null || string2 == null) {
                            this.connection = object.getConnection();
                            break block13;
                        }
                        this.connection = object.getConnection(this.username, string2);
                    }
                    catch (NamingException namingException) {
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 300, namingException.getMessage());
                    }
                } else if (this.getUrl() != null) {
                    String string3;
                    if (!this.driverManagerInitialized) {
                        DriverManager.registerDriver(new OracleDriver());
                        this.driverManagerInitialized = true;
                    }
                    if ((string3 = this.getUrl()).equals("") || string.equals("") || string2.equals("")) {
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 301);
                    }
                    this.connection = DriverManager.getConnection(string3, string, string2);
                } else {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 301);
                }
            }
        }
        return this.connection;
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.resultSet == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 305);
        }
        return this.resultSet.getStatement();
    }

    public RowSetReader getReader() {
        return this.reader;
    }

    public RowSetWriter getWriter() {
        return this.writer;
    }

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        if (this.rowsetType == 1005) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 306);
        }
        switch (n2) {
            case 1000: 
            case 1002: {
                this.presentRow = 0;
                break;
            }
            case 1001: {
                if (this.rowsetType == 1003) {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 307);
                }
                this.presentRow = this.rowCount + 1;
                break;
            }
            default: {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 308);
            }
        }
        super.setFetchDirection(n2);
    }

    @Override
    public void setCommand(String string) throws SQLException {
        super.setCommand(string);
        this.osql = string == null || string.equals("") ? null : new OracleSqlForRowSet(string);
    }

    public void setReader(RowSetReader rowSetReader) {
        this.reader = rowSetReader;
    }

    public void setWriter(RowSetWriter rowSetWriter) {
        this.writer = rowSetWriter;
    }

    private final int getColumnIndex(String string) throws SQLException {
        int n2;
        if (string == null || string.equals("")) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 6, string);
        }
        string = string.toUpperCase();
        for (n2 = 0; n2 < this.metaData.length && !string.equals(this.metaData[n2]); ++n2) {
        }
        if (n2 >= this.metaData.length) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 6, string);
        }
        return n2 + 1;
    }

    private final void checkColumnIndex(int n2) throws SQLException {
        if (this.readOnly) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 309);
        }
        if (n2 < 1 || n2 > this.colCount) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + n2);
        }
    }

    private final boolean isUpdated(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.colCount) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + n2);
        }
        return this.getCurrentRow().isColumnChanged(n2);
    }

    private final void checkParamIndex(int n2) throws SQLException {
        if (n2 < 1) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 310, "" + n2);
        }
    }

    private final void populateInit(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        Statement statement = resultSet.getStatement();
        this.maxFieldSize = statement.getMaxFieldSize();
        this.fetchSize = statement.getFetchSize();
        this.queryTimeout = statement.getQueryTimeout();
        this.connection = statement.getConnection();
        this.transactionIsolation = this.connection.getTransactionIsolation();
        this.typeMap = this.connection.getTypeMap();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        this.url = databaseMetaData.getURL();
        this.username = databaseMetaData.getUserName();
    }

    private synchronized InputStream getStream(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new ByteArrayInputStream(((String)object).getBytes());
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        if (object instanceof OracleSerialClob) {
            return ((OracleSerialClob)object).getAsciiStream();
        }
        if (object instanceof OracleSerialBlob) {
            return ((OracleSerialBlob)object).getBinaryStream();
        }
        if (object instanceof Reader) {
            try {
                BufferedReader bufferedReader = new BufferedReader((Reader)object);
                int n3 = 0;
                PipedInputStream pipedInputStream = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
                while ((n3 = ((Reader)bufferedReader).read()) != -1) {
                    pipedOutputStream.write(n3);
                }
                pipedOutputStream.close();
                return pipedInputStream;
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 311, iOException.getMessage());
            }
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 312);
        return null;
    }

    @Override
    protected synchronized void notifyCursorMoved() {
        if (this.insertRowFlag) {
            this.insertRowFlag = false;
            this.insertRow.setRowUpdated(false);
            this.sqlWarning.setNextWarning(new SQLWarning("Cancelling insertion, due to cursor movement."));
        } else if (this.updateRowFlag) {
            try {
                this.updateRowFlag = false;
                int n2 = this.presentRow;
                this.presentRow = this.updateRowPosition;
                this.getCurrentRow().setRowUpdated(false);
                this.presentRow = n2;
                this.sqlWarning.setNextWarning(new SQLWarning("Cancelling all updates, due to cursor movement."));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.notifyCursorMoved();
    }

    protected void checkAndFilterObject(int n2, Object object) throws SQLException {
    }

    OracleRow getCurrentRow() throws SQLException {
        int n2 = this.presentRow - 1;
        if (this.presentRow < 1 || this.presentRow > this.rowCount) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 313);
        }
        return (OracleRow)this.rows.elementAt(this.presentRow - 1);
    }

    boolean isConnectionStayingOpen() {
        return this.isConnectionStayingOpenForTxnControl;
    }

    void setOriginal() throws SQLException {
        int n2 = 1;
        do {
            boolean bl;
            if (bl = this.setOriginalRowInternal(n2)) continue;
            ++n2;
        } while (n2 <= this.rowCount);
        this.notifyRowSetChanged();
        this.presentRow = 0;
    }

    boolean setOriginalRowInternal(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.rowCount) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 313);
        }
        boolean bl = false;
        OracleRow oracleRow = (OracleRow)this.rows.elementAt(n2 - 1);
        if (oracleRow.isRowDeleted()) {
            this.rows.remove(n2 - 1);
            --this.rowCount;
            bl = true;
        } else {
            if (oracleRow.isRowInserted()) {
                oracleRow.setInsertedFlag(false);
            }
            if (oracleRow.isRowUpdated()) {
                oracleRow.makeUpdatesOriginal();
            }
        }
        return bl;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.presentRow + 1 <= this.rowCount) {
                ++this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.presentRow - 1 > 0) {
                --this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = 0;
            return false;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.presentRow + 1 <= this.rowCount) {
                ++this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.presentRow - 1 > 0) {
                --this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = 0;
            return false;
        }
        return false;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.rowCount > 0 && this.presentRow == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.rowCount > 0 && this.presentRow == this.rowCount + 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.presentRow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.presentRow == this.rowCount;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.presentRow = 0;
    }

    @Override
    public void afterLast() throws SQLException {
        this.presentRow = this.rowCount + 1;
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        if (this.rowsetType == 1003) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 314);
        }
        if (n2 == 0 || Math.abs(n2) > this.rowCount) {
            return false;
        }
        this.presentRow = n2 < 0 ? this.rowCount + n2 + 1 : n2;
        this.notifyCursorMoved();
        return true;
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        return this.absolute(this.presentRow + n2);
    }

    @Override
    public synchronized void populate(ResultSet resultSet) throws SQLException {
        int n2;
        if (this.rows == null) {
            this.rows = new Vector(50, 10);
        } else {
            this.rows.clear();
        }
        this.rowsetMetaData = new OracleRowSetMetaData(resultSet.getMetaData());
        this.colCount = this.rowsetMetaData.getColumnCount();
        this.metaData = new String[this.colCount];
        for (n2 = 0; n2 < this.colCount; ++n2) {
            this.metaData[n2] = this.rowsetMetaData.getColumnName(n2 + 1);
        }
        if (!(resultSet instanceof OracleCachedRowSet)) {
            this.populateInit(resultSet);
        }
        n2 = this.fetchDirection == 1000 || this.fetchDirection == 1002 ? 1 : 0;
        this.rowCount = 0;
        OracleRow oracleRow = null;
        int n3 = this.maxRows == 0 && this.pageSize == 0 ? Integer.MAX_VALUE : (this.maxRows == 0 || this.pageSize == 0 ? Math.max(this.maxRows, this.pageSize) : Math.min(this.maxRows, this.pageSize));
        if (resultSet.getType() != 1003 && this.rows.size() == 0 && n2 == 0) {
            resultSet.afterLast();
        }
        while (this.rowCount < n3 && !(n2 != 0 ? !resultSet.next() : !resultSet.previous())) {
            oracleRow = new OracleRow(this.colCount);
            for (int i2 = 1; i2 <= this.colCount; ++i2) {
                Object object = null;
                try {
                    object = resultSet.getObject(i2, this.typeMap);
                }
                catch (Exception exception) {
                    object = resultSet.getObject(i2);
                }
                catch (AbstractMethodError abstractMethodError) {
                    object = resultSet.getObject(i2);
                }
                if (object instanceof Clob || object instanceof CLOB) {
                    oracleRow.setColumnValue(i2, new OracleSerialClob((Clob)object));
                } else if (object instanceof Blob || object instanceof BLOB) {
                    oracleRow.setColumnValue(i2, new OracleSerialBlob((Blob)object));
                } else {
                    oracleRow.setColumnValue(i2, object);
                }
                oracleRow.markOriginalNull(i2, resultSet.wasNull());
            }
            if (n2 != 0) {
                this.rows.add(oracleRow);
            } else {
                this.rows.add(1, oracleRow);
            }
            ++this.rowCount;
        }
        if (n2 != 0 && resultSet.isAfterLast() || n2 == 0 && resultSet.isBeforeFirst()) {
            this.isPopulateDone = true;
        }
        this.connection = null;
        this.notifyRowSetChanged();
    }

    @Override
    public String getCursorName() throws SQLException {
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        return null;
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        this.param = null;
        this.param = new Vector();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.previousColumnWasNull;
    }

    @Override
    public void close() throws SQLException {
        this.release();
        this.isClosed = true;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowsetMetaData;
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.getColumnIndex(string);
    }

    @Override
    public Object[] getParams() throws SQLException {
        return this.param.toArray();
    }

    @Override
    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        this.rowsetMetaData = rowSetMetaData;
        if (rowSetMetaData != null) {
            this.colCount = rowSetMetaData.getColumnCount();
        }
    }

    @Override
    public synchronized void execute() throws SQLException {
        this.isConnectionStayingOpenForTxnControl = false;
        this.getReader().readData(this);
    }

    @Override
    public void acceptChanges() throws SyncProviderException {
        try {
            this.getWriter().writeData(this);
        }
        catch (SQLException sQLException) {
            throw new SyncProviderException(sQLException.getMessage());
        }
    }

    @Override
    public void acceptChanges(Connection connection) throws SyncProviderException {
        this.connection = connection;
        this.isConnectionStayingOpenForTxnControl = true;
        this.acceptChanges();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return this.createCopy();
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException("SQL Error occured while cloning: " + sQLException.getMessage());
        }
    }

    @Override
    public CachedRowSet createCopy() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createShared();
        int n2 = this.rows.size();
        oracleCachedRowSet.rows = new Vector(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            oracleCachedRowSet.rows.add(((OracleRow)this.rows.elementAt(i2)).createCopy());
        }
        return oracleCachedRowSet;
    }

    @Override
    public RowSet createShared() throws SQLException {
        int n2;
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rows = this.rows;
        oracleCachedRowSet.setDataSource(this.getDataSource());
        oracleCachedRowSet.setDataSourceName(this.getDataSourceName());
        oracleCachedRowSet.setUsername(this.getUsername());
        oracleCachedRowSet.setPassword(this.getPassword());
        oracleCachedRowSet.setUrl(this.getUrl());
        oracleCachedRowSet.setTypeMap(this.getTypeMap());
        oracleCachedRowSet.setMaxFieldSize(this.getMaxFieldSize());
        oracleCachedRowSet.setMaxRows(this.getMaxRows());
        oracleCachedRowSet.setQueryTimeout(this.getQueryTimeout());
        oracleCachedRowSet.setFetchSize(this.getFetchSize());
        oracleCachedRowSet.setEscapeProcessing(this.getEscapeProcessing());
        oracleCachedRowSet.setConcurrency(this.getConcurrency());
        oracleCachedRowSet.setReadOnly(this.readOnly);
        this.rowsetType = this.getType();
        this.fetchDirection = this.getFetchDirection();
        oracleCachedRowSet.setCommand(this.getCommand());
        oracleCachedRowSet.setTransactionIsolation(this.getTransactionIsolation());
        oracleCachedRowSet.presentRow = this.presentRow;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.rowCount = this.rowCount;
        oracleCachedRowSet.showDeleted = this.showDeleted;
        oracleCachedRowSet.syncProvider = this.syncProvider;
        oracleCachedRowSet.currentPage = this.currentPage;
        oracleCachedRowSet.pageSize = this.pageSize;
        oracleCachedRowSet.tableName = this.tableName == null ? null : new String(this.tableName);
        oracleCachedRowSet.keyColumns = this.keyColumns == null ? null : (int[])this.keyColumns.clone();
        int n3 = this.listener.size();
        for (n2 = 0; n2 < n3; ++n2) {
            oracleCachedRowSet.listener.add(this.listener.elementAt(n2));
        }
        oracleCachedRowSet.rowsetMetaData = new OracleRowSetMetaData(this.rowsetMetaData);
        n3 = this.param.size();
        for (n2 = 0; n2 < n3; ++n2) {
            oracleCachedRowSet.param.add(this.param.elementAt(n2));
        }
        oracleCachedRowSet.metaData = new String[this.metaData.length];
        System.arraycopy(this.metaData, 0, oracleCachedRowSet.metaData, 0, this.metaData.length);
        return oracleCachedRowSet;
    }

    @Override
    public void release() throws SQLException {
        this.rows = null;
        this.rows = new Vector();
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.rowCount = 0;
        this.presentRow = 0;
        this.notifyRowSetChanged();
    }

    @Override
    public void restoreOriginal() throws SQLException {
        boolean bl = false;
        for (int i2 = 0; i2 < this.rowCount; ++i2) {
            OracleRow oracleRow = (OracleRow)this.rows.elementAt(i2);
            if (oracleRow.isRowInserted()) {
                this.rows.remove(i2);
                --this.rowCount;
                --i2;
                bl = true;
                continue;
            }
            if (oracleRow.isRowUpdated()) {
                oracleRow.setRowUpdated(false);
                bl = true;
                continue;
            }
            if (!oracleRow.isRowDeleted()) continue;
            oracleRow.setRowDeleted(false);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 315);
        } else {
            this.notifyRowSetChanged();
        }
        this.presentRow = 0;
    }

    public Collection toCollection() throws SQLException {
        Map<Integer, Collection> map = Collections.synchronizedMap(new TreeMap());
        try {
            for (int i2 = 0; i2 < this.rowCount; ++i2) {
                map.put(new Integer(i2), ((OracleRow)this.rows.elementAt(i2)).toCollection());
            }
        }
        catch (Exception exception) {
            map = null;
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 316);
        }
        return map.values();
    }

    public Collection toCollection(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.colCount) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + n2);
        }
        Vector<Object> vector = new Vector<Object>(this.rowCount);
        for (int i2 = 0; i2 < this.rowCount; ++i2) {
            OracleRow oracleRow = (OracleRow)this.rows.elementAt(i2);
            Object object = oracleRow.isColumnChanged(n2) ? oracleRow.getModifiedColumn(n2) : oracleRow.getColumn(n2);
            vector.add(object);
        }
        return vector;
    }

    public Collection toCollection(String string) throws SQLException {
        return this.toCollection(this.getColumnIndex(string));
    }

    @Override
    public int getRow() throws SQLException {
        if (this.presentRow > this.rowCount) {
            return this.rowCount;
        }
        return this.presentRow;
    }

    public void cancelRowInsert() throws SQLException {
        if (this.getCurrentRow().isRowInserted()) {
            this.rows.remove(--this.presentRow);
            --this.rowCount;
            this.notifyRowChanged();
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 317);
        }
    }

    public void cancelRowDelete() throws SQLException {
        if (this.getCurrentRow().isRowDeleted()) {
            this.getCurrentRow().setRowDeleted(false);
            this.notifyRowChanged();
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 318);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (this.getCurrentRow().isRowUpdated()) {
            this.updateRowFlag = false;
            this.getCurrentRow().setRowUpdated(false);
            this.notifyRowChanged();
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 319);
        }
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.insertRowFlag) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 317);
        }
        if (!this.insertRow.isRowFullyPopulated()) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 320);
        }
        this.insertRow.insertRow();
        this.rows.insertElementAt(this.insertRow, this.insertRowPosition - 1);
        this.insertRowFlag = false;
        ++this.rowCount;
        this.notifyRowChanged();
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.updateRowFlag) {
            this.updateRowFlag = false;
            this.getCurrentRow().setRowUpdated(true);
            this.notifyRowChanged();
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 319);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        this.getCurrentRow().setRowDeleted(true);
        this.notifyRowChanged();
    }

    @Override
    public void refreshRow() throws SQLException {
        OracleRow oracleRow = this.getCurrentRow();
        if (oracleRow.isRowUpdated()) {
            oracleRow.cancelRowUpdates();
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.insertRow = new OracleRow(this.colCount, true);
        this.insertRowFlag = true;
        this.insertRowPosition = this.isAfterLast() ? this.presentRow : this.presentRow + 1;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.insertRowFlag = false;
        this.updateRowFlag = false;
        this.absolute(this.presentRow);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.getCurrentRow().isRowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.getCurrentRow().isRowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.getCurrentRow().isRowDeleted();
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        oracleCachedRowSet.rowCount = 1;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.presentRow = 0;
        oracleCachedRowSet.setReader(null);
        oracleCachedRowSet.setWriter(null);
        OracleRow oracleRow = new OracleRow(this.rowsetMetaData.getColumnCount(), this.getCurrentRow().getOriginalRow());
        oracleCachedRowSet.rows.add(oracleRow);
        return oracleCachedRowSet;
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        oracleCachedRowSet.rowCount = this.rowCount;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.presentRow = 0;
        oracleCachedRowSet.setType(1004);
        oracleCachedRowSet.setConcurrency(1008);
        oracleCachedRowSet.setReader(null);
        oracleCachedRowSet.setWriter(null);
        int n2 = this.rowsetMetaData.getColumnCount();
        OracleRow oracleRow = null;
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            oracleRow = new OracleRow(n2, ((OracleRow)iterator.next()).getOriginalRow());
            oracleCachedRowSet.rows.add(oracleRow);
        }
        return oracleCachedRowSet;
    }

    @Override
    public void setNull(int n2, int n3) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, null);
    }

    @Override
    public void setNull(int n2, int n3, String string) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{new Integer(n3), string};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setBoolean(int n2, boolean bl) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Boolean(bl));
    }

    @Override
    public void setByte(int n2, byte by) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Byte(by));
    }

    @Override
    public void setShort(int n2, short s2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Short(s2));
    }

    @Override
    public void setInt(int n2, int n3) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Integer(n3));
    }

    @Override
    public void setLong(int n2, long l2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Long(l2));
    }

    @Override
    public void setFloat(int n2, float f2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Float(f2));
    }

    @Override
    public void setDouble(int n2, double d2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Double(d2));
    }

    @Override
    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, bigDecimal);
    }

    @Override
    public void setString(int n2, String string) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, string);
    }

    @Override
    public void setBytes(int n2, byte[] byArray) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, byArray);
    }

    @Override
    public void setDate(int n2, Date date) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, date);
    }

    @Override
    public void setTime(int n2, Time time) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, time);
    }

    @Override
    public void setObject(int n2, Object object) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, object);
    }

    @Override
    public void setRef(int n2, Ref ref) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, ref);
    }

    @Override
    public void setBlob(int n2, Blob blob) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, blob);
    }

    @Override
    public void setClob(int n2, Clob clob) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, clob);
    }

    @Override
    public void setArray(int n2, Array array) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, array);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Integer(n3), new Integer(2)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{time, calendar};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{timestamp, calendar};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, timestamp);
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Integer(n3), new Integer(3)};
        this.param.add(n2 - 1, objectArray);
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Integer(n3), new Integer(1)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, new Integer(n3), new Integer(4)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{object, new Integer(n3), new Integer(n4)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{object, new Integer(n3)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{date, calendar};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setURL(int n2, URL uRL) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, uRL);
    }

    @Override
    public synchronized Object getObject(int n2) throws SQLException {
        int n3 = this.presentRow * this.colCount + n2 - 1;
        Object object = null;
        object = !this.isUpdated(n2) ? this.getCurrentRow().getColumn(n2) : this.getCurrentRow().getModifiedColumn(n2);
        this.previousColumnWasNull = object == null;
        return object;
    }

    private synchronized Number getNumber(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof BigDecimal || object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Boolean) {
            return new Integer((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof String) {
            try {
                return new BigDecimal((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
            }
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
        }
        return null;
    }

    public Object getObject(int n2, Map map) throws SQLException {
        return this.getObject(n2);
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
        return false;
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            return ((String)object).getBytes()[0];
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return oracleSerialBlob.getBytes(1L, 1)[0];
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(0L, 1).getBytes()[0];
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
        return 0;
    }

    @Override
    public short getShort(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? (short)0 : number.shortValue();
    }

    @Override
    public int getInt(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0 : number.intValue();
    }

    @Override
    public long getLong(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0L : number.longValue();
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0.0f : number.floatValue();
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0.0 : number.doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        if (number == null || number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Number) {
            return new BigDecimal(number.doubleValue());
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this.getBigDecimal(n2);
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (Date)object;
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            return new Date(time.getTime());
        }
        if (object instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)object;
            return new Date(date.getYear(), date.getMonth(), date.getDate());
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
        return null;
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.getDate(n2);
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (Time)object;
        }
        if (object instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)object;
            return new Time(date.getHours(), date.getMinutes(), date.getSeconds());
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
        return null;
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.getTime(n2);
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)object).getTime());
        }
        if (object instanceof TIMESTAMP) {
            return ((TIMESTAMP)object).timestampValue();
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
        return null;
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.getTimestamp(n2);
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (byte[])object;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        if (object instanceof Number) {
            return ((Number)object).toString().getBytes();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toString().getBytes();
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return oracleSerialBlob.getBytes(1L, (int)oracleSerialBlob.length());
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(0L, (int)oracleSerialClob.length()).getBytes();
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
        return null;
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof Ref) {
            return (Ref)object;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
        return null;
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object instanceof OracleSerialBlob) {
            return object == null ? null : (Blob)object;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
        return null;
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object instanceof OracleSerialClob) {
            return object == null ? null : (Clob)object;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
        return null;
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof Array) {
            return (Array)object;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
        return null;
    }

    @Override
    public String getString(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (String)object;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number || object instanceof BigDecimal) {
            return object.toString();
        }
        if (object instanceof Date) {
            return object.toString();
        }
        if (object instanceof Timestamp) {
            return object.toString();
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(0L, (int)oracleSerialClob.length());
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return new String(oracleSerialBlob.getBytes(1L, (int)oracleSerialBlob.length()));
        }
        if (object instanceof URL) {
            return ((URL)object).toString();
        }
        if (object instanceof Reader) {
            try {
                Reader reader = (Reader)object;
                char[] cArray = new char[1024];
                int n3 = 0;
                StringBuffer stringBuffer = new StringBuffer(1024);
                while ((n3 = reader.read(cArray)) > 0) {
                    stringBuffer.append(cArray, 0, n3);
                }
                return stringBuffer.substring(0, stringBuffer.length());
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 321, iOException.getMessage());
            }
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
        }
        return null;
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        InputStream inputStream = this.getStream(n2);
        return inputStream == null ? null : inputStream;
    }

    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new StringBufferInputStream((String)object);
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59);
        return null;
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        InputStream inputStream = this.getStream(n2);
        return inputStream == null ? null : inputStream;
    }

    @Override
    public synchronized Reader getCharacterStream(int n2) throws SQLException {
        try {
            InputStream inputStream = this.getAsciiStream(n2);
            if (inputStream == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while ((n3 = inputStream.read()) != -1) {
                stringBuffer.append((char)n3);
            }
            char[] cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            cArray = null;
            return charArrayReader;
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 322);
            return null;
        }
    }

    @Override
    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.getColumnIndex(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getColumnIndex(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getColumnIndex(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.getColumnIndex(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.getColumnIndex(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.getColumnIndex(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getColumnIndex(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getColumnIndex(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(string), n2);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getColumnIndex(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.getColumnIndex(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getColumnIndex(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(string));
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.getColumnIndex(string), calendar);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.getColumnIndex(string), calendar);
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.getColumnIndex(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.getColumnIndex(string));
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.getColumnIndex(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.getColumnIndex(string));
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.getColumnIndex(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(string));
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(string), calendar);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.getColumnIndex(string), map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.getColumnIndex(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.getColumnIndex(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.getColumnIndex(string));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.getColumnIndex(string));
    }

    @Override
    public synchronized void updateObject(int n2, Object object) throws SQLException {
        this.checkColumnIndex(n2);
        if (this.insertRowFlag) {
            this.checkAndFilterObject(n2, object);
            this.insertRow.updateObject(n2, object);
        } else if (!this.isBeforeFirst() && !this.isAfterLast()) {
            this.updateRowFlag = true;
            this.updateRowPosition = this.presentRow;
            this.getCurrentRow().updateObject(n2, object);
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 90);
        }
    }

    @Override
    public void updateNull(int n2) throws SQLException {
        this.updateObject(n2, null);
    }

    @Override
    public synchronized void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.checkColumnIndex(n2);
        try {
            char[] cArray = new char[n3];
            int n4 = 0;
            while ((n4 += reader.read(cArray, n4, n3 - n4)) < n3) {
            }
            this.updateObject(n2, (Object)new CharArrayReader(cArray));
            cArray = null;
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 322, iOException.getMessage());
        }
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(this.getColumnIndex(string), reader, n2);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.getColumnIndex(string), timestamp);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(this.getColumnIndex(string), inputStream, n2);
    }

    @Override
    public synchronized void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            byte[] byArray = new byte[n3];
            int n4 = 0;
            while ((n4 += inputStream.read(byArray, n4, n3 - n4)) < n3) {
            }
            this.updateObject(n2, (Object)new ByteArrayInputStream(byArray));
            byArray = null;
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 322, iOException.getMessage());
        }
    }

    @Override
    public synchronized void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            char[] cArray = new char[n3];
            int n4 = 0;
            while ((n4 += inputStreamReader.read(cArray, n4, n3 - n4)) < n3) {
            }
            this.updateObject(n2, (Object)new CharArrayReader(cArray));
            cArray = null;
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 322, iOException.getMessage());
        }
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.updateObject(n2, (Object)timestamp);
    }

    @Override
    public void updateBoolean(int n2, boolean bl) throws SQLException {
        this.updateObject(n2, (Object)new Boolean(bl));
    }

    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        this.updateObject(n2, (Object)new Byte(by));
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        this.updateObject(n2, (Object)new Short(s2));
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        this.updateObject(n2, (Object)new Integer(n3));
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        this.updateObject(n2, (Object)new Long(l2));
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        this.updateObject(n2, (Object)new Float(f2));
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        this.updateObject(n2, (Object)new Double(d2));
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n2, (Object)bigDecimal);
    }

    @Override
    public void updateString(int n2, String string) throws SQLException {
        this.updateObject(n2, (Object)string);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.updateObject(n2, (Object)byArray);
    }

    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        this.updateObject(n2, (Object)date);
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        this.updateObject(n2, (Object)new Timestamp(0, 0, 0, time.getHours(), time.getMinutes(), time.getSeconds(), 0));
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        if (!(object instanceof Number)) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 323);
        }
        this.updateObject(n2, (Object)new BigDecimal(new BigInteger(((Number)object).toString()), n3));
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.getColumnIndex(string));
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(this.getColumnIndex(string), inputStream, n2);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.getColumnIndex(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.getColumnIndex(string), by);
    }

    @Override
    public void updateShort(String string, short s2) throws SQLException {
        this.updateShort(this.getColumnIndex(string), s2);
    }

    @Override
    public void updateInt(String string, int n2) throws SQLException {
        this.updateInt(this.getColumnIndex(string), n2);
    }

    @Override
    public void updateLong(String string, long l2) throws SQLException {
        this.updateLong(this.getColumnIndex(string), l2);
    }

    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.getColumnIndex(string), f2);
    }

    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.getColumnIndex(string), d2);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.getColumnIndex(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.getColumnIndex(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.getColumnIndex(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.getColumnIndex(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.getColumnIndex(string), time);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.getColumnIndex(string), object);
    }

    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.updateObject(this.getColumnIndex(string), object, n2);
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (URL)object;
        }
        if (object instanceof URL) {
            return (URL)object;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
        return null;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.getColumnIndex(string));
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        this.updateObject(n2, (Object)ref);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.getColumnIndex(string), ref);
    }

    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.updateObject(n2, (Object)blob);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.getColumnIndex(string), blob);
    }

    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        this.updateObject(n2, (Object)clob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.getColumnIndex(string), clob);
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        this.updateObject(n2, (Object)array);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.getColumnIndex(string), array);
    }

    @Override
    public int[] getKeyColumns() throws SQLException {
        return this.keyColumns;
    }

    @Override
    public void setKeyColumns(int[] nArray) throws SQLException {
        int n2 = 0;
        if (this.rowsetMetaData != null) {
            n2 = this.rowsetMetaData.getColumnCount();
            if (nArray == null || nArray.length > n2) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 324);
            }
        }
        int n3 = nArray.length;
        this.keyColumns = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] <= 0 || nArray[i2] > n2) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + nArray[i2]);
            }
            this.keyColumns[i2] = nArray[i2];
        }
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int n2) throws SQLException {
        if (n2 < 0 || this.maxRows > 0 && n2 > this.maxRows) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 325);
        }
        this.pageSize = n2;
    }

    @Override
    public SyncProvider getSyncProvider() throws SQLException {
        return this.syncProvider;
    }

    @Override
    public void setSyncProvider(String string) throws SQLException {
        this.syncProvider = SyncFactory.getInstance(string);
        this.reader = this.syncProvider.getRowSetReader();
        this.writer = this.syncProvider.getRowSetWriter();
    }

    @Override
    public String getTableName() throws SQLException {
        return this.tableName;
    }

    @Override
    public void setTableName(String string) throws SQLException {
        this.tableName = string;
    }

    @Override
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createCopy();
        oracleCachedRowSet.initializeProperties();
        oracleCachedRowSet.listener = new Vector();
        try {
            oracleCachedRowSet.unsetMatchColumn(oracleCachedRowSet.getMatchColumnIndexes());
            oracleCachedRowSet.unsetMatchColumn(oracleCachedRowSet.getMatchColumnNames());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return oracleCachedRowSet;
    }

    @Override
    public CachedRowSet createCopySchema() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createCopy();
        oracleCachedRowSet.rows = null;
        oracleCachedRowSet.rowCount = 0;
        oracleCachedRowSet.currentPage = 0;
        return oracleCachedRowSet;
    }

    @Override
    public boolean columnUpdated(int n2) throws SQLException {
        if (this.insertRowFlag) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 326);
        }
        return this.getCurrentRow().isColumnChanged(n2);
    }

    @Override
    public boolean columnUpdated(String string) throws SQLException {
        return this.columnUpdated(this.getColumnIndex(string));
    }

    @Override
    public synchronized void execute(Connection connection) throws SQLException {
        this.connection = connection;
        this.execute();
    }

    @Override
    public void commit() throws SQLException {
        this.getConnectionInternal().commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.getConnectionInternal().rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Connection connection = this.getConnectionInternal();
        boolean bl = connection.getAutoCommit();
        try {
            connection.setAutoCommit(false);
            connection.rollback(savepoint);
        }
        finally {
            connection.setAutoCommit(bl);
        }
    }

    public void oracleRollback(OracleSavepoint oracleSavepoint) throws SQLException {
        ((OracleConnection)this.getConnectionInternal()).oracleRollback(oracleSavepoint);
    }

    @Override
    public void setOriginalRow() throws SQLException {
        if (this.insertRowFlag) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 327);
        }
        this.setOriginalRowInternal(this.presentRow);
    }

    @Override
    public int size() {
        return this.rowCount;
    }

    @Override
    public boolean nextPage() throws SQLException {
        if (this.fetchDirection == 1001 && this.resultSet != null && this.resultSet.getType() == 1003) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 328);
        }
        if (this.rows.size() == 0 && !this.isPopulateDone) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 329);
        }
        this.populate(this.resultSet);
        ++this.currentPage;
        return !this.isPopulateDone;
    }

    @Override
    public boolean previousPage() throws SQLException {
        if (this.resultSet != null && this.resultSet.getType() == 1003) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 328);
        }
        if (this.rows.size() == 0 && !this.isPopulateDone) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 329);
        }
        if (this.fetchDirection == 1001) {
            this.resultSet.relative(this.pageSize * 2);
        } else {
            this.resultSet.relative(-2 * this.pageSize);
        }
        this.populate(this.resultSet);
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        return this.currentPage != 0;
    }

    @Override
    public void rowSetPopulated(RowSetEvent rowSetEvent, int n2) throws SQLException {
        if (n2 <= 0 || n2 < this.fetchSize) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 330);
        }
        if (this.rowCount % n2 == 0) {
            this.rowsetEvent = new RowSetEvent(this);
            this.notifyRowSetChanged();
        }
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        return this.rowsetWarning;
    }

    @Override
    public void populate(ResultSet resultSet, int n2) throws SQLException {
        int n3;
        if (n2 < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 331);
        }
        if (resultSet == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 332);
        }
        if ((n3 = resultSet.getType()) == 1003) {
            int n4;
            for (n4 = 0; resultSet.next() && n4 < n2; ++n4) {
            }
            if (n4 < n2) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 333);
            }
        } else {
            resultSet.absolute(n2);
        }
        this.populate(resultSet);
    }

    @Override
    public void undoDelete() throws SQLException {
        this.cancelRowDelete();
    }

    @Override
    public void undoInsert() throws SQLException {
        this.cancelRowInsert();
    }

    @Override
    public void undoUpdate() throws SQLException {
        this.cancelRowUpdates();
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        return this.getCharacterStream(n2);
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object instanceof OracleSerialClob) {
            return object == null ? null : (NClob)object;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
        return null;
    }

    @Override
    public String getNString(int n2) throws SQLException {
        return this.getString(n2);
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object instanceof RowId) {
            return object == null ? null : (RowId)object;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
        return null;
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.getColumnIndex(string));
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.getColumnIndex(string));
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getNString(this.getColumnIndex(string));
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return this.getRowId(this.getColumnIndex(string));
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.getColumnIndex(string));
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Integer(7)};
        this.param.add(n2 - 1, objectArray);
    }

    public void setAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Long(l2), new Integer(8)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Integer(5)};
        this.param.add(n2 - 1, objectArray);
    }

    public void setBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Long(l2), new Integer(6)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setBlob(int n2, InputStream inputStream) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Integer(13)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, new Long(l2), new Integer(14)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, new Integer(9)};
        this.param.add(n2 - 1, objectArray);
    }

    public void setCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, new Long(l2), new Integer(10)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setClob(int n2, Reader reader) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, new Integer(15)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setClob(int n2, Reader reader, long l2) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{this.reader, new Long(l2), new Integer(16)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, new Integer(11)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, new Long(l2), new Integer(12)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setNClob(int n2, NClob nClob) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, nClob);
    }

    @Override
    public void setNClob(int n2, Reader reader) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{this.reader, new Integer(17)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setNClob(int n2, Reader reader, long l2) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{this.reader, new Long(l2), new Integer(18)};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setNString(int n2, String string) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, string);
    }

    @Override
    public void setRowId(int n2, RowId rowId) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, rowId);
    }

    @Override
    public void setSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, sQLXML);
    }

    public void setArray(String string, Array array) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setArray(i2 + 1, array);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBigDecimal(i2 + 1, bigDecimal);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBlob(i2 + 1, blob);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBoolean(i2 + 1, bl);
            bl2 = true;
        }
        if (!bl2) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setByte(i2 + 1, by);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBytes(i2 + 1, byArray);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setClob(i2 + 1, clob);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setDate(i2 + 1, date);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setDate(i2 + 1, date, calendar);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setDouble(String string, double d2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setDouble(i2 + 1, d2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setFloat(String string, float f2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setFloat(i2 + 1, f2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setInt(String string, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setInt(i2 + 1, n2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setLong(String string, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setLong(i2 + 1, l2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNClob(i2 + 1, nClob);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string3) continue;
            this.setNString(i2 + 1, string2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setObject(i2 + 1, object);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setObject(String string, Object object, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setObject(i2 + 1, object, n2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    public void setRef(String string, Ref ref) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setRef(i2 + 1, ref);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setRowId(i2 + 1, rowId);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setShort(String string, short s2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setShort(i2 + 1, s2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setSQLXML(i2 + 1, sQLXML);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string3) continue;
            this.setString(i2 + 1, string2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTime(i2 + 1, time);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTime(i2 + 1, time, calendar);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTimestamp(i2 + 1, timestamp);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTimestamp(i2 + 1, timestamp, calendar);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    public void setURL(String string, URL uRL) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setURL(i2 + 1, uRL);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBlob(i2 + 1, inputStream);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBlob(i2 + 1, inputStream, l2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setClob(i2 + 1, reader);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setClob(String string, Reader reader, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setClob(i2 + 1, reader, l2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNClob(i2 + 1, reader);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setNClob(String string, Reader reader, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNClob(i2 + 1, reader, l2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setAsciiStream(i2 + 1, inputStream);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setAsciiStream(i2 + 1, inputStream, n2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    public void setAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setAsciiStream(i2 + 1, inputStream, l2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBinaryStream(i2 + 1, inputStream);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBinaryStream(i2 + 1, inputStream, n2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    public void setBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBinaryStream(i2 + 1, inputStream, l2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setCharacterStream(i2 + 1, reader);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setCharacterStream(i2 + 1, reader, n2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    public void setCharacterStream(String string, Reader reader, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setCharacterStream(i2 + 1, reader, l2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNCharacterStream(i2 + 1, reader);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNCharacterStream(i2 + 1, reader, l2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    public void setUnicodeStream(String string, InputStream inputStream, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setUnicodeStream(i2 + 1, inputStream, n2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setNull(String string, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNull(i2 + 1, n2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setNull(String string, int n2, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string3) continue;
            this.setNull(i2 + 1, n2, string2);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n4 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setObject(i2 + 1, object, n2, n3);
            bl = true;
        }
        if (!bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, string);
        }
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(n2, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.updateAsciiStream(n2, inputStream, (int)l2);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.getColumnIndex(string), inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.updateAsciiStream(this.getColumnIndex(string), inputStream, l2);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n2, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.updateBinaryStream(n2, inputStream, (int)l2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.getColumnIndex(string), inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.updateBinaryStream(this.getColumnIndex(string), inputStream, l2);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n2, inputStream);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        this.updateBlob(n2, inputStream, (long)((int)l2));
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(this.getColumnIndex(string), inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) throws SQLException {
        this.updateBlob(this.getColumnIndex(string), inputStream, l2);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        this.updateCharacterStream(n2, reader, Integer.MAX_VALUE);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.updateCharacterStream(n2, reader, (int)l2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.getColumnIndex(string), reader);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.updateCharacterStream(this.getColumnIndex(string), reader, l2);
    }

    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        this.updateCharacterStream(n2, reader);
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        this.updateClob(n2, reader, (long)((int)l2));
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(this.getColumnIndex(string), reader);
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) throws SQLException {
        this.updateClob(this.getColumnIndex(string), reader, l2);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        this.updateNCharacterStream(n2, reader, Integer.MAX_VALUE);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.updateCharacterStream(n2, reader, (int)l2);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.getColumnIndex(string), reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.updateNCharacterStream(this.getColumnIndex(string), reader, l2);
    }

    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        this.updateObject(n2, (Object)nClob);
    }

    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        this.updateClob(n2, reader);
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) throws SQLException {
        this.updateNClob(n2, reader, (long)((int)l2));
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.updateNClob(this.getColumnIndex(string), nClob);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.updateNClob(this.getColumnIndex(string), reader);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) throws SQLException {
        this.updateNClob(this.getColumnIndex(string), reader, l2);
    }

    @Override
    public void updateNString(int n2, String string) throws SQLException {
        this.updateObject(n2, (Object)string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.updateNString(this.getColumnIndex(string), string2);
    }

    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        this.updateObject(n2, (Object)rowId);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.updateRowId(this.getColumnIndex(string), rowId);
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        this.updateObject(n2, (Object)sQLXML);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.updateSQLXML(this.getColumnIndex(string), sQLXML);
    }
}

