/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.JoinRowSet;
import javax.sql.rowset.Joinable;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleJDBCRowSet;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleWebRowSet;

public class OracleJoinRowSet
extends OracleWebRowSet
implements JoinRowSet {
    private static final String MATCH_COLUMN_SUFFIX = "#MATCH_COLUMN";
    private static boolean[] supportedJoins = new boolean[]{false, true, false, false, false};
    private int joinType = 1;
    private Vector addedRowSets = new Vector();
    private Vector addedRowSetNames = new Vector();
    private Object lockForJoinActions;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_08:38:12_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    @Override
    public synchronized void addRowSet(Joinable joinable) throws SQLException {
        if (joinable == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 350);
        }
        if (!(joinable instanceof RowSet)) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 351);
        }
        OracleCachedRowSet oracleCachedRowSet = this.checkAndWrapRowSet((RowSet)((Object)joinable));
        String string = this.getMatchColumnTableName((RowSet)((Object)joinable));
        switch (this.joinType) {
            case 1: {
                this.doInnerJoin(oracleCachedRowSet);
                this.addedRowSets.add(joinable);
                this.addedRowSetNames.add(string);
                break;
            }
            default: {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 352);
            }
        }
    }

    @Override
    public synchronized void addRowSet(RowSet rowSet, int n2) throws SQLException {
        ((OracleRowSet)((Object)rowSet)).setMatchColumn(n2);
        this.addRowSet((Joinable)((Object)rowSet));
    }

    @Override
    public synchronized void addRowSet(RowSet rowSet, String string) throws SQLException {
        ((OracleRowSet)((Object)rowSet)).setMatchColumn(string);
        this.addRowSet((Joinable)((Object)rowSet));
    }

    @Override
    public synchronized void addRowSet(RowSet[] rowSetArray, int[] nArray) throws SQLException {
        if (rowSetArray.length != nArray.length) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 353);
        }
        for (int i2 = 0; i2 < rowSetArray.length; ++i2) {
            ((OracleRowSet)((Object)rowSetArray[i2])).setMatchColumn(nArray[i2]);
            this.addRowSet((Joinable)((Object)rowSetArray[i2]));
        }
    }

    @Override
    public synchronized void addRowSet(RowSet[] rowSetArray, String[] stringArray) throws SQLException {
        if (rowSetArray.length != stringArray.length) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 353);
        }
        for (int i2 = 0; i2 < rowSetArray.length; ++i2) {
            ((OracleRowSet)((Object)rowSetArray[i2])).setMatchColumn(stringArray[i2]);
            this.addRowSet((Joinable)((Object)rowSetArray[i2]));
        }
    }

    public Collection getRowSets() throws SQLException {
        return this.addedRowSets;
    }

    @Override
    public String[] getRowSetNames() throws SQLException {
        Object[] objectArray = this.addedRowSetNames.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            stringArray[i2] = (String)objectArray[i2];
        }
        return stringArray;
    }

    @Override
    public CachedRowSet toCachedRowSet() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createCopy();
        oracleCachedRowSet.setCommand("");
        return oracleCachedRowSet;
    }

    @Override
    public int getJoinType() {
        return this.joinType;
    }

    @Override
    public boolean supportsCrossJoin() {
        return supportedJoins[0];
    }

    @Override
    public boolean supportsInnerJoin() {
        return supportedJoins[1];
    }

    @Override
    public boolean supportsLeftOuterJoin() {
        return supportedJoins[2];
    }

    @Override
    public boolean supportsRightOuterJoin() {
        return supportedJoins[3];
    }

    @Override
    public boolean supportsFullJoin() {
        return supportedJoins[4];
    }

    @Override
    public void setJoinType(int n2) throws SQLException {
        if (n2 != 1) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 352);
        }
        this.joinType = n2;
    }

    @Override
    public synchronized String getWhereClause() throws SQLException {
        if (this.addedRowSets.size() < 2) {
            return "WHERE";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE\n");
        OracleRowSet oracleRowSet = (OracleRowSet)this.addedRowSets.get(0);
        int[] nArray = oracleRowSet.getMatchColumnIndexes();
        ResultSetMetaData resultSetMetaData = oracleRowSet.getMetaData();
        String string = oracleRowSet.getTableName();
        for (int i2 = 1; i2 < this.addedRowSets.size(); ++i2) {
            if (i2 > 1) {
                stringBuffer.append("\nAND\n");
            }
            OracleRowSet oracleRowSet2 = (OracleRowSet)this.addedRowSets.get(i2);
            int[] nArray2 = oracleRowSet2.getMatchColumnIndexes();
            ResultSetMetaData resultSetMetaData2 = oracleRowSet2.getMetaData();
            String string2 = oracleRowSet2.getTableName();
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                if (i3 > 0) {
                    stringBuffer.append("\nAND\n");
                }
                stringBuffer.append("(" + string + "." + resultSetMetaData.getColumnName(nArray[i3]) + " = " + string2 + "." + resultSetMetaData2.getColumnName(nArray2[i3]) + ")");
            }
            oracleRowSet = oracleRowSet2;
            nArray = nArray2;
            resultSetMetaData = resultSetMetaData2;
            string = string2;
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    private void doInnerJoin(OracleCachedRowSet oracleCachedRowSet) throws SQLException {
        if (this.addedRowSets.isEmpty()) {
            this.setMetaData((RowSetMetaData)oracleCachedRowSet.getMetaData());
            this.populate(oracleCachedRowSet);
            this.setMatchColumn(oracleCachedRowSet.getMatchColumnIndexes());
        } else {
            int n2;
            int n3;
            int n4;
            boolean bl;
            Vector<OracleRow> vector = new Vector<OracleRow>(100);
            OracleRowSetMetaData oracleRowSetMetaData = new OracleRowSetMetaData(10);
            int[] nArray = this.getMatchColumnIndexes();
            int[] nArray2 = oracleCachedRowSet.getMatchColumnIndexes();
            int n5 = this.getMetaData().getColumnCount() + oracleCachedRowSet.getMetaData().getColumnCount() - nArray2.length;
            oracleRowSetMetaData.setColumnCount(n5);
            String string = this.getTableName() + "#" + oracleCachedRowSet.getTableName();
            for (int i2 = 1; i2 <= this.colCount; ++i2) {
                bl = false;
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    if (i2 != nArray[n4]) continue;
                    bl = true;
                    break;
                }
                this.setNewColumnMetaData(i2, oracleRowSetMetaData, i2, (RowSetMetaData)this.rowsetMetaData, bl, string);
            }
            RowSetMetaData rowSetMetaData = (RowSetMetaData)oracleCachedRowSet.getMetaData();
            n4 = rowSetMetaData.getColumnCount();
            int n6 = this.colCount + 1;
            int[] nArray3 = new int[n4];
            for (n3 = 1; n3 <= n4; ++n3) {
                bl = false;
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    if (n3 != nArray[n2]) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.setNewColumnMetaData(n6, oracleRowSetMetaData, n3, rowSetMetaData, bl, string);
                    nArray3[n3 - 1] = n6++;
                    continue;
                }
                nArray3[n3 - 1] = -1;
            }
            this.beforeFirst();
            n3 = oracleCachedRowSet.size();
            n2 = 0;
            for (int i3 = 1; i3 <= this.rowCount; ++i3) {
                this.next();
                oracleCachedRowSet.beforeFirst();
                for (int i4 = 1; i4 <= n3; ++i4) {
                    int n7;
                    oracleCachedRowSet.next();
                    n2 = 1;
                    for (int i5 = 0; i5 < nArray.length; ++i5) {
                        Object object;
                        Object object2 = this.getObject(nArray[i5]);
                        if (object2.equals(object = oracleCachedRowSet.getObject(nArray2[i5]))) continue;
                        n2 = 0;
                        break;
                    }
                    if (n2 == 0) continue;
                    OracleRow oracleRow = new OracleRow(n5, true);
                    for (n7 = 1; n7 <= this.colCount; ++n7) {
                        oracleRow.updateObject(n7, this.getObject(n7));
                    }
                    for (n7 = 1; n7 <= n4; ++n7) {
                        if (nArray3[n7 - 1] == -1) continue;
                        oracleRow.updateObject(nArray3[n7 - 1], oracleCachedRowSet.getObject(n7));
                    }
                    vector.add(oracleRow);
                }
            }
            this.rows = vector;
            this.presentRow = 0;
            this.rowCount = this.rows.size();
            this.setMetaData(oracleRowSetMetaData);
        }
    }

    private void setNewColumnMetaData(int n2, RowSetMetaData rowSetMetaData, int n3, RowSetMetaData rowSetMetaData2, boolean bl, String string) throws SQLException {
        rowSetMetaData.setAutoIncrement(n2, rowSetMetaData2.isAutoIncrement(n3));
        rowSetMetaData.setCaseSensitive(n2, rowSetMetaData2.isCaseSensitive(n3));
        rowSetMetaData.setCatalogName(n2, rowSetMetaData2.getCatalogName(n3));
        rowSetMetaData.setColumnDisplaySize(n2, rowSetMetaData2.getColumnDisplaySize(n3));
        if (bl) {
            rowSetMetaData.setColumnName(n2, rowSetMetaData2.getColumnName(n2) + MATCH_COLUMN_SUFFIX);
        } else {
            rowSetMetaData.setColumnName(n2, rowSetMetaData2.getColumnName(n3));
        }
        rowSetMetaData.setColumnLabel(n2, rowSetMetaData.getColumnName(n3));
        rowSetMetaData.setColumnType(n2, rowSetMetaData2.getColumnType(n3));
        rowSetMetaData.setColumnTypeName(n2, rowSetMetaData2.getColumnTypeName(n3));
        rowSetMetaData.setCurrency(n2, rowSetMetaData2.isCurrency(n3));
        rowSetMetaData.setNullable(n2, rowSetMetaData2.isNullable(n3));
        rowSetMetaData.setPrecision(n2, rowSetMetaData2.getPrecision(n3));
        rowSetMetaData.setScale(n2, rowSetMetaData2.getScale(n3));
        rowSetMetaData.setSchemaName(n2, rowSetMetaData2.getSchemaName(n3));
        rowSetMetaData.setSearchable(n2, rowSetMetaData2.isSearchable(n3));
        rowSetMetaData.setSigned(n2, rowSetMetaData2.isSigned(n3));
        if (bl) {
            rowSetMetaData.setTableName(n2, string);
        } else {
            rowSetMetaData.setTableName(n2, rowSetMetaData2.getTableName(n3));
        }
    }

    private OracleCachedRowSet checkAndWrapRowSet(RowSet rowSet) throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = null;
        if (rowSet instanceof OracleCachedRowSet) {
            oracleCachedRowSet = (OracleCachedRowSet)rowSet;
        } else if (rowSet instanceof OracleJDBCRowSet) {
            oracleCachedRowSet = new OracleCachedRowSet();
            oracleCachedRowSet.populate(rowSet);
            int[] nArray = ((OracleJDBCRowSet)rowSet).getMatchColumnIndexes();
            oracleCachedRowSet.setMatchColumn(nArray);
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 354);
        }
        return oracleCachedRowSet;
    }

    private String getMatchColumnTableName(RowSet rowSet) throws SQLException {
        String string = null;
        if (rowSet instanceof OracleRowSet) {
            string = ((OracleRowSet)((Object)rowSet)).getTableName();
        }
        return string;
    }
}

