/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.localhistory;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.localhistory.Sql;
import pl.mpak.orbada.localhistory.services.LocalHistoryDatabaseService;
import pl.mpak.orbada.localhistory.services.LocalHistoryLastChangesActionService;
import pl.mpak.orbada.localhistory.services.LocalHistorySchemaSettingsService;
import pl.mpak.orbada.localhistory.services.LocalHistorySettingsService;
import pl.mpak.orbada.localhistory.services.LocalHistorySyntaxService;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.OrbadaPlugin;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.util.ScriptUtil;
import pl.mpak.plugins.spi.IPlugin;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.usedb.core.Command;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.VersionID;
import pl.mpak.util.timer.TimerManager;
import pl.mpak.util.timer.TimerQueue;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbadaLocalHistoryPlugin
extends OrbadaPlugin {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaLocalHistoryPlugin.class);
    public static final String pluginGroupName = stringManager.getString("OrbadaLocalHistoryPlugin-group-name");
    private static TimerQueue refreshQueue;
    private static ISettings settings;

    public static TimerQueue getRefreshQueue() {
        if (refreshQueue == null) {
            refreshQueue = TimerManager.getTimer((String)"orbada-local-history-refresh");
        }
        return refreshQueue;
    }

    public String getInternalName() {
        return "OrbadaLocalHistoryPlugin";
    }

    public String getDescriptiveName() {
        return String.format(stringManager.getString("OrbadaLocalHistoryPlugin-descriptive-name"), this.getVersion());
    }

    public String getDescription() {
        return "";
    }

    public String getCategory() {
        return "IDE,Tools,Developers,Diff";
    }

    public String getAuthor() {
        return "Andrzej Ka\u0142u\u017ca";
    }

    public String getCopyrights() {
        return "";
    }

    public String getWebSite() {
        return null;
    }

    public String getUpdateSite() {
        return null;
    }

    public String getVersion() {
        return new VersionID(1, 0, 1, 9).toString();
    }

    public String getLicence() {
        return null;
    }

    public String getUniqueID() {
        return "orbada-local-history-plugin";
    }

    public void load() {
    }

    public void unload() {
    }

    public void initialize() {
        settings = this.application.getSettings(LocalHistorySettingsService.settingsName);
        if (this.application.isUserAdmin()) {
            if (this.getLastVersion() == null) {
                ScriptUtil.executeInternalScript((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/pl/mpak/orbada/localhistory/sql/creation.sql"));
            } else if (new VersionID(this.getLastVersion()).getBuild() < 8) {
                if ("oralce".equalsIgnoreCase(InternalDatabase.get().getDriverType())) {
                    ScriptUtil.executeInternalScript((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/pl/mpak/orbada/localhistory/sql/oracle-1-0-1-8.sql"));
                } else if ("postgresql".equalsIgnoreCase(InternalDatabase.get().getDriverType())) {
                    ScriptUtil.executeInternalScript((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/pl/mpak/orbada/localhistory/sql/postgresql-1-0-1-8.sql"));
                } else {
                    ScriptUtil.executeInternalScript((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/pl/mpak/orbada/localhistory/sql/hsqldb-1-0-1-8.sql"));
                }
            }
        }
        if (this.getLastVersion() != null) {
            this.deleteOldest();
        }
    }

    public boolean requires(List<IPlugin> loadedPlugins) {
        return true;
    }

    public Class<IPluginProvider>[] getProviderArray() {
        return new Class[]{LocalHistoryDatabaseService.class, LocalHistorySyntaxService.class, LocalHistorySchemaSettingsService.class, LocalHistorySettingsService.class, LocalHistoryLastChangesActionService.class};
    }

    public void processMessage(PluginMessage message) {
    }

    private void deleteOldest() {
        int deleteAfterDays = settings.getValue(LocalHistorySettingsService.setDeleteAfterDays, Long.valueOf(30L)).intValue();
        try {
            Variant v = new Variant(new Date()).subtract(new Variant(deleteAfterDays));
            Command command = this.application.getOrbadaDatabase().createCommand(Sql.getDeleteOldest(), false);
            command.paramByName("OLHO_CREATED").setTimestamp(v.getTimestamp());
            command.paramByName("USR_ID").setString(this.application.getUserId());
            command.execute();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public static ISettings getSettings() {
        return settings;
    }
}

