/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.localhistory.cm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.orbada.gui.comps.AbsOrbadaSyntaxTextArea;
import pl.mpak.orbada.localhistory.OrbadaLocalHistoryPlugin;
import pl.mpak.orbada.localhistory.core.SchemaObjects;
import pl.mpak.orbada.localhistory.db.OlhObjectRecord;
import pl.mpak.orbada.localhistory.gui.DiffViewService;
import pl.mpak.orbada.localhistory.services.LocalHistoryDatabaseService;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class LocalHistoryObjectAction
extends Action {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaLocalHistoryPlugin.class);
    private AbsOrbadaSyntaxTextArea syntaxTextArea;

    public LocalHistoryObjectAction(AbsOrbadaSyntaxTextArea syntaxTextArea) {
        this.setText(this.stringManager.getString("LocalHistoryObjectAction-text"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/diff.gif"));
        this.setActionCommandKey("LocalHistoryObjectAction");
        this.addActionListener(this.createActionListener());
        this.syntaxTextArea = syntaxTextArea;
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SchemaObjects so = LocalHistoryDatabaseService.getSchemaObjects(LocalHistoryObjectAction.this.syntaxTextArea.getDatabase());
                if (so != null) {
                    PerspectivePanel panel = (PerspectivePanel)LocalHistoryObjectAction.this.getParent(e, PerspectivePanel.class);
                    OlhObjectRecord olho = so.getObject(LocalHistoryObjectAction.this.syntaxTextArea.getSchemaName(), LocalHistoryObjectAction.this.syntaxTextArea.getObjectType(), LocalHistoryObjectAction.this.syntaxTextArea.getObjectName());
                    if (panel != null && olho != null) {
                        panel.getPerspectiveAccesibilities().createView((ViewProvider)new DiffViewService(olho, (SyntaxTextArea)LocalHistoryObjectAction.this.syntaxTextArea));
                    }
                }
            }
        };
    }
}

