/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.localhistory.core;

import java.util.HashMap;
import pl.mpak.orbada.localhistory.OrbadaLocalHistoryPlugin;
import pl.mpak.orbada.localhistory.Sql;
import pl.mpak.orbada.localhistory.db.OlhObjectRecord;
import pl.mpak.orbada.localhistory.services.LocalHistorySettingsService;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.TaskUtil;
import pl.mpak.util.task.Task;
import pl.mpak.util.timer.Timer;

public class SchemaObjects {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaLocalHistoryPlugin.class);
    private IApplication application;
    private volatile Database database;
    private final HashMap<String, OlhObjectRecord> objectList = new HashMap();
    private volatile boolean loading;
    private volatile boolean canceled;
    private volatile boolean writted = true;
    private Timer writeTimer;
    private ISettings settings;
    private boolean tunedOn;

    public SchemaObjects(IApplication application, Database database) {
        this.application = application;
        this.database = database;
        this.writeTimer = this.getWriteTimer();
        this.settings = application.getSettings(database.getUserProperties().getProperty("schemaId"), LocalHistorySettingsService.settingsName);
        this.tunedOn = this.getSettings().getValue(LocalHistorySettingsService.setGlobalSettings, Boolean.valueOf(true)) == false && this.getSettings().getValue(LocalHistorySettingsService.setTurnedOn, Boolean.valueOf(true)) != false || this.getSettings().getValue(LocalHistorySettingsService.setGlobalSettings, Boolean.valueOf(true)) != false && OrbadaLocalHistoryPlugin.getSettings().getValue(LocalHistorySettingsService.setTurnedOn, Boolean.valueOf(true)) != false;
        OrbadaLocalHistoryPlugin.getRefreshQueue().add(this.writeTimer);
    }

    private Timer getWriteTimer() {
        return new Timer(10000L){

            public void run() {
                SchemaObjects.this.writeHistory();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHistory() {
        if (!this.writted) {
            HashMap<String, OlhObjectRecord> hashMap = this.objectList;
            synchronized (hashMap) {
                for (OlhObjectRecord olho : this.objectList.values()) {
                    if (!olho.isChanged()) continue;
                    try {
                        olho.applyInsert();
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
                this.writted = true;
            }
        }
    }

    private String getKey(String schemaName, String objectType, String objectName) {
        return objectType + " " + StringUtil.nvl((String)schemaName, (String)"") + "." + objectName;
    }

    public void loadLastObjects() {
        this.loading = true;
        this.application.getOrbadaDatabase().getTaskPool().addTask(new Task(this.stringManager.getString("SchemaObjects-loading-connection-history")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashMap hashMap = SchemaObjects.this.objectList;
                synchronized (hashMap) {
                    Query query = SchemaObjects.this.application.getOrbadaDatabase().createQuery();
                    try {
                        query.setSqlText(Sql.getLastLhObjectCount(null));
                        query.paramByName("sch_id").setString(SchemaObjects.this.database.getUserProperties().getProperty("schemaId"));
                        query.open();
                        long count = query.fieldByName("cnt").getLong();
                        query.setSqlText(Sql.getLastLhObjectList(null));
                        query.paramByName("sch_id").setString(SchemaObjects.this.database.getUserProperties().getProperty("schemaId"));
                        query.open();
                        long i = 0L;
                        while (!query.eof()) {
                            OlhObjectRecord olho = new OlhObjectRecord(SchemaObjects.this.application.getOrbadaDatabase());
                            olho.updateFrom(query);
                            SchemaObjects.this.objectList.put(SchemaObjects.this.getKey(olho.getObjectSchema(), olho.getObjectType(), olho.getObjectName()), olho);
                            if (SchemaObjects.this.canceled) {
                                break;
                            }
                            if (++i % 10L == 0L) {
                                this.setPercenExecution((int)((double)i / (double)count * 100.0));
                            }
                            query.next();
                        }
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                    finally {
                        SchemaObjects.this.loading = false;
                        query.close();
                    }
                }
            }
        });
    }

    public void cancel() {
        this.canceled = true;
        this.writeTimer.cancel();
        if (!this.loading) {
            this.writeHistory();
        }
        while (this.loading || !this.writted) {
            TaskUtil.sleep((long)10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlhObjectRecord getObject(String schemaName, String objectType, String objectName) {
        HashMap<String, OlhObjectRecord> hashMap = this.objectList;
        synchronized (hashMap) {
            return this.objectList.get(this.getKey(schemaName, objectType, objectName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(String schemaName, String objectType, String objectName, String source) {
        HashMap<String, OlhObjectRecord> hashMap = this.objectList;
        synchronized (hashMap) {
            this.writted = false;
            OlhObjectRecord record = new OlhObjectRecord(this.application.getOrbadaDatabase());
            record.setObjectSchema(schemaName);
            record.setObjectType(objectType);
            record.setObjectName(objectName);
            record.setSchId(this.database.getUserProperties().getProperty("schemaId"));
            record.setSource(source);
            this.objectList.put(this.getKey(schemaName, objectType, objectName), record);
        }
    }

    public ISettings getSettings() {
        return this.settings;
    }

    public boolean isTurnedOn() {
        return this.tunedOn;
    }
}

