/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.localhistory.db;

import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;
import pl.mpak.util.variant.VariantException;

public class OlhObjectRecord
extends DefaultBufferedRecord {
    public OlhObjectRecord(Database database) {
        super(database, "OLHOBJECTS", "OLHO_ID");
        this.add("OLHO_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("OLHO_SCH_ID", 11, true);
        this.add("OLHO_CREATED", 20, true);
        this.add("OLHO_OBJECT_SCHEMA", 11, true);
        this.add("OLHO_OBJECT_TYPE", 11, true);
        this.add("OLHO_OBJECT_NAME", 11, true);
        this.add("OLHO_SOURCE", 11, true);
        this.add("OLHO_DESCRIPTION", 11, true);
    }

    public OlhObjectRecord(Database database, String osm_id) throws UseDBException {
        this(database);
        this.loadRecord(new Variant(osm_id));
    }

    public String getId() {
        return this.fieldByName("OLHO_ID").getValue().toString();
    }

    public void setId(String id) {
        this.fieldByName("OLHO_ID").setString(id);
    }

    public String getSchId() {
        return this.fieldByName("OLHO_SCH_ID").getValue().toString();
    }

    public void setSchId(String id) {
        this.fieldByName("OLHO_SCH_ID").setString(id);
    }

    public Long getCreated() {
        try {
            return this.fieldByName("OLHO_CREATED").getLong();
        }
        catch (VariantException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setCreated(Long created) {
        this.fieldByName("OLHO_CREATED").setLong(created.longValue());
    }

    public void setCreated(String created) {
        this.fieldByName("OLHO_CREATED").setString(created);
    }

    public String getObjectSchema() {
        return this.fieldByName("OLHO_OBJECT_SCHEMA").getValue().toString();
    }

    public void setObjectSchema(String schemaName) {
        this.fieldByName("OLHO_OBJECT_SCHEMA").setString(schemaName);
    }

    public String getObjectType() {
        return this.fieldByName("OLHO_OBJECT_TYPE").getValue().toString();
    }

    public void setObjectType(String objectType) {
        this.fieldByName("OLHO_OBJECT_TYPE").setString(objectType);
    }

    public String getObjectName() {
        return this.fieldByName("OLHO_OBJECT_NAME").getValue().toString();
    }

    public void setObjectName(String objectName) {
        this.fieldByName("OLHO_OBJECT_NAME").setString(objectName);
    }

    public String getSource() {
        return this.fieldByName("OLHO_SOURCE").getValue().toString();
    }

    public void setSource(String source) {
        this.fieldByName("OLHO_SOURCE").setString(source);
    }

    public String getDescription() {
        return this.fieldByName("OLHO_DESCRIPTION").getValue().toString();
    }

    public void setDescription(String description) {
        this.fieldByName("OLHO_DESCRIPTION").setString(description);
    }

    public void applyInsert() throws Exception {
        if (!this.fieldByName("OLHO_CREATED").isChanged()) {
            this.fieldByName("OLHO_CREATED").setValue(new Variant(System.currentTimeMillis()));
        }
        super.applyInsert();
    }

    public String toString() {
        return this.getObjectType() + " " + SQLUtil.createSqlName((String)this.getObjectSchema(), (String)this.getObjectName());
    }
}

