/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.localhistory.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jmeld.ui.JMeldPanel;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.localhistory.OrbadaLocalHistoryPlugin;
import pl.mpak.orbada.localhistory.Sql;
import pl.mpak.orbada.localhistory.core.SchemaObjects;
import pl.mpak.orbada.localhistory.db.OlhObjectRecord;
import pl.mpak.orbada.localhistory.services.LocalHistoryDatabaseService;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.patt.Resolvers;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class DiffViewPanel
extends JPanel
implements Closeable {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaLocalHistoryPlugin.class);
    private OlhObjectRecord olho;
    private SyntaxTextArea syntaxTextArea;
    private IViewAccesibilities accesibilities;
    private boolean viewClosing = false;
    private Timer timer;
    private JMeldPanel meldPanel;
    private ArrayList<File> fileList;
    private String tempDir;
    private File oryginalFile;
    private boolean reloading;
    private ToolButton buttonActions;
    private ToolButton buttonCommentChange;
    private ToolButton buttonRefresh;
    private Action cmCommentChange;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private JSplitPane split;
    private ViewTable tableHistory;
    private JToolBar toolBar;

    public DiffViewPanel(IViewAccesibilities accesibilities, OlhObjectRecord olho, SyntaxTextArea syntaxTextArea) {
        this.accesibilities = accesibilities;
        this.olho = olho;
        this.syntaxTextArea = syntaxTextArea;
        this.tempDir = Resolvers.expand((String)"$(java.io.tmpdir)");
        this.fileList = new ArrayList();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                DiffViewPanel.this.reloadDiff();
            }
        };
        OrbadaLocalHistoryPlugin.getRefreshQueue().add(this.timer);
        this.tableHistory.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!DiffViewPanel.this.reloading) {
                    DiffViewPanel.this.timer.restart();
                }
            }
        });
        this.tableHistory.getQuery().setDatabase(this.accesibilities.getApplication().getOrbadaDatabase());
        this.tableHistory.addColumn((TableColumn)new QueryTableColumn("olho_created", this.stringManager.getString("date"), 140, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableHistory.addColumn((TableColumn)new QueryTableColumn("source_size", this.stringManager.getString("size"), 80));
        this.tableHistory.addColumn((TableColumn)new QueryTableColumn("olho_description", this.stringManager.getString("comment"), 700));
        new ComponentActionsAction(this.accesibilities.getDatabase(), (JComponent)this.tableHistory, (JButton)this.buttonActions, this.menuActions, "local-history-object-actions");
        this.meldPanel = new JMeldPanel();
        this.split.setBottomComponent((Component)this.meldPanel);
        this.oryginalFile = new File(this.tempDir + "/" + this.olho.getObjectType() + " " + this.olho.getObjectSchema() + " " + this.olho.getObjectName());
        try {
            this.syntaxTextArea.saveToFile(this.oryginalFile);
        }
        catch (IOException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.fileList.add(this.oryginalFile);
    }

    private void refreshTableListTask() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DiffViewPanel.this.refreshTableList();
            }
        });
    }

    private void refreshTableList() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String olho_id = null;
            if (this.tableHistory.getQuery().isActive() && this.tableHistory.getSelectedRow() >= 0) {
                this.tableHistory.getQuery().getRecord(this.tableHistory.getSelectedRow());
                olho_id = this.tableHistory.getQuery().fieldByName("olho_id").getString();
            }
            this.refreshTableList(olho_id);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refreshTableList(String olho_id) {
        try {
            int column = this.tableHistory.getSelectedColumn();
            int index = Math.max(0, this.tableHistory.getSelectedRow());
            this.tableHistory.getQuery().close();
            this.tableHistory.getQuery().setSqlText(Sql.getObjectHistoryList());
            this.tableHistory.getQuery().paramByName("SCH_ID").setString(this.accesibilities.getDatabase().getUserProperties().getProperty("schemaId"));
            this.tableHistory.getQuery().paramByName("SCHEMA_NAME").setString(this.olho.getObjectSchema());
            this.tableHistory.getQuery().paramByName("OBJECT_TYPE").setString(this.olho.getObjectType());
            this.tableHistory.getQuery().paramByName("OBJECT_NAME").setString(this.olho.getObjectName());
            this.tableHistory.getQuery().open();
            if (olho_id != null && this.tableHistory.getQuery().locate("olho_id", new Variant(olho_id))) {
                this.tableHistory.changeSelection(this.tableHistory.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableHistory.getQuery().isEmpty()) {
                this.tableHistory.changeSelection(Math.min(index, this.tableHistory.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.timer.cancel();
        this.tableHistory.getQuery().close();
        for (File file : this.fileList) {
            file.delete();
        }
        this.accesibilities = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadDiff() {
        if (this.tableHistory.getQuery().isActive() && this.tableHistory.getSelectedRow() >= 0) {
            try {
                this.tableHistory.getQuery().getRecord(this.tableHistory.getSelectedRow());
                File file = new File(this.tempDir + "/" + this.tableHistory.getQuery().fieldByName("olho_id").getString());
                if (this.fileList.indexOf(file) == -1) {
                    OlhObjectRecord record = new OlhObjectRecord(this.accesibilities.getApplication().getOrbadaDatabase(), this.tableHistory.getQuery().fieldByName("olho_id").getString());
                    FileOutputStream os = new FileOutputStream(file);
                    try {
                        ((OutputStream)os).write(record.getSource().getBytes());
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                    this.fileList.add(file);
                }
                this.meldPanel.openFileComparison(this.oryginalFile, file, false);
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void initComponents() {
        this.menuActions = new JPopupMenu();
        this.cmRefresh = new Action();
        this.cmCommentChange = new Action();
        this.split = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonCommentChange = new ToolButton();
        this.buttonActions = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableHistory = new ViewTable();
        this.cmRefresh.setActionCommandKey("cmRefresh");
        this.cmRefresh.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/refresh16.gif")));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DiffViewPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmCommentChange.setActionCommandKey("cmCommentChange");
        this.cmCommentChange.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/comment_edit.gif")));
        this.cmCommentChange.setText(this.stringManager.getString("cmCommentChange-text"));
        this.cmCommentChange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DiffViewPanel.this.cmCommentChangeActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                DiffViewPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.split.setBorder(null);
        this.split.setDividerLocation(110);
        this.split.setOrientation(0);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.toolBar.add(this.jSeparator1);
        this.buttonCommentChange.setAction((javax.swing.Action)this.cmCommentChange);
        this.buttonCommentChange.setHorizontalTextPosition(0);
        this.buttonCommentChange.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonCommentChange);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBar);
        this.jPanel1.add((Component)this.jPanel2, "North");
        this.jScrollPane1.setViewportView((Component)this.tableHistory);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.split.setTopComponent(this.jPanel1);
        this.add((Component)this.split, "Center");
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refreshTableList();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableHistory.getQuery().isActive() && !this.viewClosing) {
            this.refreshTableListTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmCommentChangeActionPerformed(ActionEvent evt) {
        block7: {
            if (this.tableHistory.getQuery().isActive() && this.tableHistory.getSelectedRow() >= 0) {
                try {
                    this.tableHistory.getQuery().getRecord(this.tableHistory.getSelectedRow());
                    SchemaObjects so = LocalHistoryDatabaseService.getSchemaObjects(this.accesibilities.getDatabase());
                    if (so == null) break block7;
                    OlhObjectRecord olho_u = new OlhObjectRecord(this.accesibilities.getApplication().getOrbadaDatabase(), this.tableHistory.getQuery().fieldByName("olho_id").getString());
                    String description = JOptionPane.showInputDialog(this.stringManager.getString("DiffViewPanel-last-comment"), (Object)olho_u.getDescription());
                    if (description == null) break block7;
                    olho_u.setDescription(description);
                    try {
                        olho_u.applyUpdate();
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                        MessageBox.show((Component)this.syntaxTextArea, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                    }
                    this.reloading = true;
                    try {
                        this.refreshTableList();
                    }
                    catch (Throwable throwable) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                DiffViewPanel.this.reloading = false;
                            }
                        });
                        throw throwable;
                    }
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        }
    }
}

