/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.localhistory.gui;

import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import pl.mpak.orbada.localhistory.OrbadaLocalHistoryPlugin;
import pl.mpak.orbada.localhistory.services.LocalHistorySettingsService;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class GeneralSettingsPanel
extends JPanel
implements ISettingsComponent {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaLocalHistoryPlugin.class);
    private IApplication application;
    private ISettings settings;
    private JCheckBox checkTurnedOn;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSpinner spinDeleteAfterDays;

    public GeneralSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.spinDeleteAfterDays.setModel(new SpinnerNumberModel(1, 0, 1000, 1));
        this.settings = this.application.getSettings(LocalHistorySettingsService.settingsName);
        this.restoreSettings();
    }

    public void restoreSettings() {
        this.spinDeleteAfterDays.setValue(this.settings.getValue(LocalHistorySettingsService.setDeleteAfterDays, Long.valueOf(30L)).intValue());
        this.checkTurnedOn.setSelected(this.settings.getValue(LocalHistorySettingsService.setTurnedOn, Boolean.valueOf(true)));
    }

    public void applySettings() {
        this.settings.setValue(LocalHistorySettingsService.setDeleteAfterDays, Long.valueOf(((Integer)this.spinDeleteAfterDays.getValue()).intValue()));
        this.settings.setValue(LocalHistorySettingsService.setTurnedOn, Boolean.valueOf(this.checkTurnedOn.isSelected()));
        this.settings.store();
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.spinDeleteAfterDays = new JSpinner();
        this.jLabel2 = new JLabel();
        this.checkTurnedOn = new JCheckBox();
        this.jLabel1.setText(this.stringManager.getString("GeneralSettingsPanel-remember-history-past-dd"));
        this.jLabel2.setText(this.stringManager.getString("days"));
        this.checkTurnedOn.setText(this.stringManager.getString("GeneralSettingsPanel-checkTurnedOn-text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkTurnedOn).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinDeleteAfterDays, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2))).addContainerGap(237, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkTurnedOn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.spinDeleteAfterDays, -2, 22, -2)).addContainerGap(297, Short.MAX_VALUE)));
    }
}

