/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.localhistory.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.localhistory.OrbadaLocalHistoryPlugin;
import pl.mpak.orbada.plugins.DatabaseObject;
import pl.mpak.orbada.plugins.IPerspectiveAccesibilities;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TableRowChangeKeyListener;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.DefaultQueryListener;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class LastChangesDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaLocalHistoryPlugin.class);
    private ISettings settings;
    private IPerspectiveAccesibilities perspective;
    private JButton buttonCancel;
    private JButton buttonShow;
    private Action cmCancel;
    private Action cmSearch;
    private Action cmShow;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private ViewTable table;
    private TextField textSearch;
    private ToolButton toolButton1;

    public LastChangesDialog(IPerspectiveAccesibilities perspective) {
        super(SwingUtil.getRootFrame());
        this.perspective = perspective;
        this.initComponents();
        this.init();
    }

    public static void showDialog(IPerspectiveAccesibilities perspective) {
        LastChangesDialog dialog = new LastChangesDialog(perspective);
        dialog.setVisible(true);
    }

    private void init() {
        this.settings = this.perspective.getApplication().getSettings("local-history-last-changes-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", new Variant(this.getWidth())).getInteger(), this.settings.getValue("height", new Variant(this.getHeight())).getInteger());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonShow);
        this.table.getQuery().setDatabase(InternalDatabase.get());
        this.table.getQuery().addQueryListener((QueryListener)new DefaultQueryListener(){

            public void afterClose(EventObject e) {
                LastChangesDialog.this.cmShow.setEnabled(false);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (LastChangesDialog.this.table.getSelectedRow() >= 0) {
                    try {
                        LastChangesDialog.this.table.getQuery().getRecord(LastChangesDialog.this.table.getSelectedRow());
                        LastChangesDialog.this.cmShow.setEnabled(e.getFirstIndex() >= 0);
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    LastChangesDialog.this.cmShow.setEnabled(false);
                }
            }
        });
        this.textSearch.addKeyListener((KeyListener)new TableRowChangeKeyListener((JTable)this.table));
        SwingUtil.addAction((JComponent)this.textSearch, (javax.swing.Action)this.cmSearch);
        try {
            this.table.addColumn((TableColumn)new QueryTableColumn("olho_object_schema", stringManager.getString("schema-name"), 100, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.table.addColumn((TableColumn)new QueryTableColumn("olho_object_name", stringManager.getString("object-name"), 200, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.table.addColumn((TableColumn)new QueryTableColumn("olho_object_type", stringManager.getString("object-type"), 100, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.NAVY)));
            this.table.addColumn((TableColumn)new QueryTableColumn("olho_created", stringManager.getString("change-date"), 120, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.table.addColumn((TableColumn)new QueryTableColumn("changes", stringManager.getString("changed"), 70, (TableCellRenderer)new QueryTableCellRenderer(Color.RED)));
            this.table.getQuery().setSqlText("select olho_object_schema, olho_object_type, olho_object_name, max(olho_created) olho_created, count(0) changes\n  from olhobjects\n where olho_sch_id = :SCH_ID\n   and (:TEXT is null or upper(olho_object_name) like concat(concat('%', upper(:TEXT)), '%'))\n group by olho_object_schema, olho_object_type, olho_object_name\n order by olho_created desc");
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    LastChangesDialog.this.refresh();
                }
            });
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonShow, this.buttonCancel});
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void refresh() {
        try {
            String objectName = null;
            if (this.table.getQuery().isActive() && !this.table.getQuery().isEmpty() && this.table.getSelectedRow() >= 0) {
                this.table.getQuery().getRecord(this.table.getSelectedRow());
                objectName = this.table.getQuery().fieldByName("olho_object_name").getString();
            }
            this.table.getQuery().close();
            this.table.getQuery().paramByName("sch_id").setString(this.perspective.getDatabase().getUserProperties().getProperty("schemaId"));
            if (!StringUtil.isEmpty((String)this.textSearch.getText())) {
                this.table.getQuery().paramByName("text").setString(this.textSearch.getText());
            } else {
                this.table.getQuery().paramByName("text").clearValue();
            }
            this.table.getQuery().open();
            if (!this.table.getQuery().isEmpty()) {
                if (objectName != null && this.table.getQuery().locate("olho_object_name", new Variant(objectName))) {
                    this.table.changeSelection(this.table.getQuery().getCurrentRecord().getIndex(), 0);
                } else {
                    this.table.changeSelection(0, 0);
                }
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void dispose() {
        this.settings.setValue("width", new Variant(this.getWidth()));
        this.settings.setValue("height", new Variant(this.getHeight()));
        this.settings.store();
        super.dispose();
    }

    private void initComponents() {
        this.cmShow = new Action();
        this.cmCancel = new Action();
        this.cmSearch = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.table = new ViewTable();
        this.buttonShow = new JButton();
        this.buttonCancel = new JButton();
        this.textSearch = new TextField();
        this.jLabel1 = new JLabel();
        this.toolButton1 = new ToolButton();
        this.cmShow.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmShow.setText(stringManager.getString("cmShow-text"));
        this.cmShow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LastChangesDialog.this.cmShowActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LastChangesDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmSearch.setActionCommandKey("cmSearch");
        this.cmSearch.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmSearch.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/find_object16.gif")));
        this.cmSearch.setText(stringManager.getString("cmSearch-text"));
        this.cmSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LastChangesDialog.this.cmSearchActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("LastChangesDialog-title"));
        this.jScrollPane1.setViewportView((Component)this.table);
        this.buttonShow.setAction((javax.swing.Action)this.cmShow);
        this.buttonShow.setMargin(new Insets(2, 2, 2, 2));
        this.buttonShow.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.jLabel1.setText(stringManager.getString("search-dd"));
        this.toolButton1.setAction((javax.swing.Action)this.cmSearch);
        this.toolButton1.setMaximumSize(new Dimension(24, 24));
        this.toolButton1.setMinimumSize(new Dimension(24, 24));
        this.toolButton1.setPreferredSize(new Dimension(24, 24));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 606, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonShow, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textSearch, -1, 537, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.toolButton1, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textSearch, -2, -1, -2).addComponent((Component)this.toolButton1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 221, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonShow, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmShowActionPerformed(ActionEvent evt) {
        block4: {
            try {
                if (this.table.getSelectedRow() < 0) break block4;
                try {
                    this.table.getQuery().getRecord(this.table.getSelectedRow());
                    DatabaseObject dbo = new DatabaseObject(this.table.getQuery().fieldByName("olho_object_schema").getString(), this.table.getQuery().fieldByName("olho_object_name").getString(), this.table.getQuery().fieldByName("olho_object_type").getString());
                    this.perspective.getApplication().postPluginMessage(new PluginMessage(this.perspective.getDatabase().getUniqueID(), "freeze-object", (Object)dbo));
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
                this.dispose();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
            }
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cmSearchActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                LastChangesDialog.this.refresh();
            }
        });
    }
}

