/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.localhistory.gui;

import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pl.mpak.orbada.localhistory.OrbadaLocalHistoryPlugin;
import pl.mpak.orbada.localhistory.services.LocalHistorySettingsService;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SchemaSettingsPanel
extends JPanel
implements ISettingsComponent {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaLocalHistoryPlugin.class);
    private Database database;
    private IApplication application;
    private ISettings settings;
    private JCheckBox checkGlobalSettings;
    private JCheckBox checkTurnedOn;
    private JLabel jLabel1;

    public SchemaSettingsPanel(IApplication application, Database database) {
        this.application = application;
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = this.application.getSettings(this.database.getUserProperties().getProperty("schemaId"), LocalHistorySettingsService.settingsName);
        this.restoreSettings();
    }

    public void restoreSettings() {
        this.checkGlobalSettings.setSelected(this.settings.getValue(LocalHistorySettingsService.setGlobalSettings, Boolean.valueOf(true)));
        this.checkTurnedOn.setSelected(this.settings.getValue(LocalHistorySettingsService.setTurnedOn, Boolean.valueOf(false)));
    }

    public void applySettings() {
        this.settings.setValue(LocalHistorySettingsService.setGlobalSettings, Boolean.valueOf(this.checkGlobalSettings.isSelected()));
        this.settings.setValue(LocalHistorySettingsService.setTurnedOn, Boolean.valueOf(this.checkTurnedOn.isSelected()));
        this.settings.store();
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void initComponents() {
        this.checkGlobalSettings = new JCheckBox();
        this.checkTurnedOn = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.checkGlobalSettings.setText(this.stringManager.getString("SchemaSettingsPanel-checkGlobalSettings-text"));
        this.checkGlobalSettings.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SchemaSettingsPanel.this.checkGlobalSettingsStateChanged(evt);
            }
        });
        this.checkTurnedOn.setText(this.stringManager.getString("SchemaSettingsPanel-checkTurnedOn-text"));
        this.jLabel1.setText(this.stringManager.getString("SchemaSettingsPanel-settings-info"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 469, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.checkTurnedOn)).addComponent(this.checkGlobalSettings)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkGlobalSettings).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkTurnedOn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 231, Short.MAX_VALUE).addComponent(this.jLabel1).addContainerGap()));
    }

    private void checkGlobalSettingsStateChanged(ChangeEvent evt) {
        this.checkTurnedOn.setEnabled(!this.checkGlobalSettings.isSelected());
    }
}

