/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.localhistory.services;

import java.util.HashMap;
import pl.mpak.orbada.localhistory.OrbadaLocalHistoryPlugin;
import pl.mpak.orbada.localhistory.core.SchemaObjects;
import pl.mpak.orbada.plugins.providers.DatabaseProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class LocalHistoryDatabaseService
extends DatabaseProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaLocalHistoryPlugin.class);
    private static HashMap<String, SchemaObjects> databaseSchemaObjects = new HashMap();

    public boolean isForDatabase(Database database) {
        return database != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnection(Database database) {
        HashMap<String, SchemaObjects> hashMap = databaseSchemaObjects;
        synchronized (hashMap) {
            SchemaObjects sh = new SchemaObjects(this.application, database);
            if (sh.isTurnedOn()) {
                sh.loadLastObjects();
            }
            databaseSchemaObjects.put(database.getUniqueID(), sh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDisconnect(Database database) {
        HashMap<String, SchemaObjects> hashMap = databaseSchemaObjects;
        synchronized (hashMap) {
            SchemaObjects sh = LocalHistoryDatabaseService.getSchemaObjects(database);
            if (sh != null) {
                sh.cancel();
            }
            databaseSchemaObjects.remove(database.getUniqueID());
        }
    }

    public String getDescription() {
        return this.stringManager.getString("LocalHistoryDatabaseService-description");
    }

    public String getGroupName() {
        return OrbadaLocalHistoryPlugin.pluginGroupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaObjects getSchemaObjects(Database database) {
        HashMap<String, SchemaObjects> hashMap = databaseSchemaObjects;
        synchronized (hashMap) {
            return databaseSchemaObjects.get(database.getUniqueID());
        }
    }
}

