/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.localhistory.services;

import java.util.EventObject;
import javax.swing.Action;
import javax.swing.JMenu;
import pl.mpak.orbada.gui.comps.AbsOrbadaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.SyntaxDatabaseObjectListener;
import pl.mpak.orbada.localhistory.OrbadaLocalHistoryPlugin;
import pl.mpak.orbada.localhistory.cm.LastChangeObjectDescriptionAction;
import pl.mpak.orbada.localhistory.cm.LocalHistoryObjectAction;
import pl.mpak.orbada.localhistory.core.SchemaObjects;
import pl.mpak.orbada.localhistory.db.OlhObjectRecord;
import pl.mpak.orbada.localhistory.services.LocalHistoryDatabaseService;
import pl.mpak.orbada.plugins.providers.OrbadaSyntaxTextAreaProvider;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class LocalHistorySyntaxService
extends OrbadaSyntaxTextAreaProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaLocalHistoryPlugin.class);
    private JMenu menu;

    public String getDescription() {
        return this.stringManager.getString("LocalHistorySyntaxService-description");
    }

    public String getGroupName() {
        return OrbadaLocalHistoryPlugin.pluginGroupName;
    }

    public void setSyntaxTextArea(SyntaxTextArea syntaxTextArea) {
        super.setSyntaxTextArea(syntaxTextArea);
        if (syntaxTextArea instanceof AbsOrbadaSyntaxTextArea) {
            ((AbsOrbadaSyntaxTextArea)syntaxTextArea).addDatabaseObjectListener(new SyntaxDatabaseObjectListener(){

                public void beforeChanged(EventObject e) {
                }

                public void afterChanged(EventObject e) {
                    LocalHistorySyntaxService.this.updateSource((AbsOrbadaSyntaxTextArea)e.getSource());
                }

                public void beforeStoreObject(EventObject e) {
                }

                public void afterStoreObject(EventObject e) {
                    LocalHistorySyntaxService.this.updateSource((AbsOrbadaSyntaxTextArea)e.getSource());
                }

                public void storeObjectError(EventObject e) {
                }
            });
            this.menu = new JMenu(this.stringManager.getString("LocalHistorySyntaxService-menu"));
            this.menu.setEnabled(false);
            this.menu.add((Action)((Object)new LocalHistoryObjectAction((AbsOrbadaSyntaxTextArea)syntaxTextArea)));
            this.menu.add((Action)((Object)new LastChangeObjectDescriptionAction((AbsOrbadaSyntaxTextArea)syntaxTextArea)));
            syntaxTextArea.getEditorArea().getComponentPopupMenu().add(this.menu);
        }
    }

    private void updateSource(AbsOrbadaSyntaxTextArea syntaxTextArea) {
        SchemaObjects sh = LocalHistoryDatabaseService.getSchemaObjects(syntaxTextArea.getDatabase());
        if (sh != null && sh.isTurnedOn() && !StringUtil.equals((String)syntaxTextArea.getObjectName(), (String)"") && !StringUtil.equals((String)syntaxTextArea.getObjectType(), (String)"")) {
            this.menu.setEnabled(true);
            String source = syntaxTextArea.getText();
            String schemaName = syntaxTextArea.getSchemaName();
            String objectType = syntaxTextArea.getObjectType();
            String objectName = syntaxTextArea.getObjectName();
            if (!"".equals(source)) {
                OlhObjectRecord olho = sh.getObject(schemaName, objectType, objectName);
                if (olho == null) {
                    sh.putObject(schemaName, objectType, objectName, source);
                } else if (!source.equals(olho.getSource())) {
                    sh.putObject(schemaName, objectType, objectName, source);
                }
            }
        } else {
            this.menu.setEnabled(false);
        }
    }
}

