/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.programmers.cm;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.programmers.OrbadaProgrammersPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.syntax.SyntaxEditor;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.array.StringList;

public class PasteCodeAction
extends Action {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaProgrammersPlugin.class);
    private SyntaxEditor editor;
    private IApplication application;

    public PasteCodeAction(IApplication application) {
        this.setText(this.stringManager.getString("PasteCodeAction-text"));
        this.application = application;
        this.setSmallIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/paste-code16.gif")));
        this.setShortCut(86, 3);
        this.setTooltip(this.stringManager.getString("PasteCodeAction-hint"));
        this.setActionCommandKey("PasteCodeAction");
        this.addActionListener(this.createActionListener());
        this.setEnabled(false);
    }

    public void setEditor(SyntaxEditor editor) {
        this.editor = editor;
    }

    private String stripCode(String data) {
        StringList sl = new StringList();
        sl.setText(data);
        for (int i = 0; i < sl.size(); ++i) {
            String line = (String)sl.get(i);
            if (!StringUtil.isEmpty((String)line) && line.indexOf("\"") < 0 && line.indexOf("'") < 0) {
                sl.set(i, (Object)("/* " + line + " */"));
                continue;
            }
            int aFirst = line.indexOf("'");
            int cFirst = line.indexOf("\"");
            int last = Math.max(line.lastIndexOf("'"), line.lastIndexOf("\""));
            if (cFirst >= 0 && (aFirst < 0 || aFirst > cFirst)) {
                line = line.substring(cFirst + 1, last);
                aFirst = -1;
            } else if (aFirst >= 0 && (cFirst < 0 || cFirst > aFirst) && last > aFirst) {
                line = line.substring(aFirst + 1, last);
                cFirst = -1;
            }
            if (line.lastIndexOf("\\n") >= 0) {
                line = line.substring(0, line.lastIndexOf("\\n"));
            }
            StringBuilder sb = new StringBuilder();
            for (int c = 0; c < line.length(); ++c) {
                char ch = line.charAt(c);
                if (ch == '\\' && c < line.length() - 1 && (line.charAt(c + 1) == '\"' || line.charAt(c + 1) == '\'' || line.charAt(c + 1) == '\\')) continue;
                if (ch == '\'' && c < line.length() - 1 && line.charAt(c + 1) == '\'' && aFirst != -1) {
                    sb.append(ch);
                    ++c;
                    continue;
                }
                if (ch == '\"' && c < line.length() - 1 && line.charAt(c + 1) == '\"' && cFirst != -1) {
                    sb.append(ch);
                    ++c;
                    continue;
                }
                sb.append(ch);
            }
            sl.set(i, (Object)sb.toString());
        }
        return sl.getText();
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PasteCodeAction.this.editor == null && FocusManager.getCurrentManager().getFocusOwner() instanceof SyntaxEditor) {
                    PasteCodeAction.this.editor = (SyntaxEditor)FocusManager.getCurrentManager().getFocusOwner();
                }
                if (PasteCodeAction.this.editor != null) {
                    try {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        Transferable content = clipboard.getContents(null);
                        if (content != null) {
                            String data = (String)content.getTransferData(DataFlavor.stringFlavor);
                            if ((data = PasteCodeAction.this.stripCode(data)) != null) {
                                if (PasteCodeAction.this.editor.getSelectionEnd() != PasteCodeAction.this.editor.getSelectionStart()) {
                                    PasteCodeAction.this.editor.replaceSelection(data);
                                } else {
                                    PasteCodeAction.this.editor.insert(data, PasteCodeAction.this.editor.getCaretPosition());
                                }
                            }
                        }
                    }
                    catch (Throwable ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
        };
    }
}

