/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.programmers.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.FocusManager;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.programmers.OrbadaProgrammersPlugin;
import pl.mpak.orbada.util.Utils;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ClassesDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaProgrammersPlugin.class);
    private VetoableChangeListener focusListener;
    private JButton buttonCancel;
    private Action cmClose;
    private JScrollPane jScrollPane1;
    private JTextArea textClasses;

    public ClassesDialog() {
        super(SwingUtil.getRootFrame(), false);
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ClassesDialog dialog = new ClassesDialog();
                dialog.setVisible(true);
            }
        });
    }

    private void init() {
        this.refresh(FocusManager.getCurrentManager().getFocusOwner());
        FocusManager.getCurrentManager().addVetoableChangeListener(this.getFocusListener());
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmClose);
        SwingUtil.centerWithinScreen((Window)this);
    }

    public void dispose() {
        FocusManager.getCurrentManager().removeVetoableChangeListener(this.getFocusListener());
        super.dispose();
    }

    private VetoableChangeListener getFocusListener() {
        if (this.focusListener == null) {
            this.focusListener = new VetoableChangeListener(){

                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if ("focusOwner".equals(evt.getPropertyName()) && evt.getNewValue() != null && evt.getNewValue() instanceof Component && !evt.getNewValue().equals(ClassesDialog.this.textClasses) && !evt.getNewValue().equals(ClassesDialog.this.buttonCancel)) {
                        ClassesDialog.this.refresh((Component)evt.getNewValue());
                    }
                }
            };
        }
        return this.focusListener;
    }

    private void refresh(Component component) {
        String classes = Utils.getComponentClasses((Component)component);
        if (this.textClasses.getText().length() > 0) {
            this.textClasses.append("----------------\n");
        }
        this.textClasses.append(classes);
    }

    private void initComponents() {
        this.cmClose = new Action();
        this.buttonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.textClasses = new JTextArea();
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(this.stringManager.getString("cmClose-text"));
        this.cmClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassesDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("ClassesDialog-title"));
        this.buttonCancel.setAction((javax.swing.Action)this.cmClose);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.textClasses.setColumns(20);
        this.textClasses.setEditable(false);
        this.textClasses.setFont(new Font("Courier New", 0, 12));
        this.textClasses.setRows(5);
        this.jScrollPane1.setViewportView(this.textClasses);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 620, Short.MAX_VALUE).addComponent(this.buttonCancel, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 352, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

