/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.programmers.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.programmers.OrbadaProgrammersPlugin;
import pl.mpak.orbada.programmers.gui.CopyCodeDefinition;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.ParameterList;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.array.StringList;
import pl.mpak.util.variant.Variant;

public class CopyCodeDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaProgrammersPlugin.class);
    private ISettings settings;
    private String text;
    private IApplication application;
    private boolean trimSpaceBars = false;
    private boolean keepFormating = false;
    private DocumentListener documentListener;
    private boolean groupUpdate;
    private JButton buttonCancel;
    private JButton buttonDelete;
    private JButton buttonNew;
    private JButton buttonOk;
    private JButton buttonUpdate;
    private JCheckBox checkKeepFormatting;
    private JCheckBox checkTrimSpaceBars;
    private Action cmCancel;
    private Action cmCopy;
    private Action cmDeleteSet;
    private Action cmNewSet;
    private Action cmUpdateSet;
    private Action cmUpdateText;
    private JComboBox comboDefinitions;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private OrbadaSyntaxTextArea syntaxSource;
    private TextField textAddAfter;
    private TextField textAddBefore;
    private TextField textAfterAll;
    private TextField textBeforeAll;
    private TextField textBeforeChars;
    private TextField textChars;
    private TextField textEndLast;
    private TextField textParamAs;
    private JTextArea textResult;

    public CopyCodeDialog(String text, IApplication application) {
        super(SwingUtil.getRootFrame());
        this.text = text;
        this.application = application;
        this.initComponents();
        this.init();
    }

    public static void show(String text, IApplication application) {
        CopyCodeDialog dialog = new CopyCodeDialog(text, application);
        dialog.setVisible(true);
    }

    private void init() {
        this.settings = this.application.getSettings("orbada-programmers-copy-code");
        try {
            this.setBounds(0, 0, this.settings.getValue("dialog-width", new Variant(this.getWidth())).getInteger(), this.settings.getValue("dialog-height", new Variant(this.getHeight())).getInteger());
        }
        catch (Exception ex) {
            // empty catch block
        }
        SwingUtil.centerWithinScreen((Window)this);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.textBeforeAll.getDocument().addDocumentListener(this.getDocumentListener());
        this.textAddBefore.getDocument().addDocumentListener(this.getDocumentListener());
        this.textBeforeChars.getDocument().addDocumentListener(this.getDocumentListener());
        this.textAddAfter.getDocument().addDocumentListener(this.getDocumentListener());
        this.textChars.getDocument().addDocumentListener(this.getDocumentListener());
        this.textEndLast.getDocument().addDocumentListener(this.getDocumentListener());
        this.textAfterAll.getDocument().addDocumentListener(this.getDocumentListener());
        this.textParamAs.getDocument().addDocumentListener(this.getDocumentListener());
        this.textResult.setFont(this.syntaxSource.getEditorArea().getFont());
        this.syntaxSource.setText(this.text);
        this.comboDefinitions.addItem(new CopyCodeDefinition("Pascal", "", "  '", "'#13#10 +", "';", "'", "'", "", "", false));
        this.comboDefinitions.addItem(new CopyCodeDefinition("C++", "", "  \"", "\\n\"", "\";", "\"\\", "\\", "", "", false));
        this.comboDefinitions.addItem(new CopyCodeDefinition("Java", "", "  \"", "\\n\" +", "\";", "\"\\", "\\", "", "? /* ($(index)) $(name) */", false));
        long userDefinitions = this.settings.getValue("user-defnition-count", Long.valueOf(0L));
        int i = 0;
        while ((long)i < userDefinitions) {
            CopyCodeDefinition cc = new CopyCodeDefinition(this.settings.getValue("user-defnition-" + i, "Unknown name"));
            cc.load(this.settings);
            this.comboDefinitions.addItem(cc);
            ++i;
        }
        this.trimSpaceBars = this.settings.getValue("trim-spacebars", Boolean.valueOf(this.trimSpaceBars));
        this.checkTrimSpaceBars.setSelected(this.trimSpaceBars);
        this.keepFormating = this.settings.getValue("keep-formating", Boolean.valueOf(this.keepFormating));
        this.checkKeepFormatting.setSelected(this.keepFormating);
        String lastSelected = this.settings.getValue("last-selected", "");
        if (!StringUtil.isEmpty((String)lastSelected)) {
            for (int i2 = 0; i2 < this.comboDefinitions.getItemCount(); ++i2) {
                CopyCodeDefinition cc = (CopyCodeDefinition)this.comboDefinitions.getItemAt(i2);
                if (!cc.getName().equals(lastSelected)) continue;
                this.comboDefinitions.setSelectedItem(cc);
            }
        }
        this.checkKeepFormatting.setEnabled(this.checkTrimSpaceBars.isSelected());
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel});
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonNew, this.buttonUpdate, this.buttonDelete});
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CopyCodeDialog.this.buttonOk.requestFocus();
            }
        });
    }

    public void dispose() {
        int userDefinitions = 0;
        for (int i = 0; i < this.comboDefinitions.getItemCount(); ++i) {
            CopyCodeDefinition cc = (CopyCodeDefinition)this.comboDefinitions.getItemAt(i);
            if (!cc.isUpdatable()) continue;
            this.settings.setValue("user-defnition-" + userDefinitions, cc.getName());
            cc.store(this.settings);
            ++userDefinitions;
        }
        this.settings.setValue("user-defnition-count", Long.valueOf(userDefinitions));
        this.settings.setValue("trim-spacebars", Boolean.valueOf(this.checkTrimSpaceBars.isSelected()));
        this.settings.setValue("keep-formating", Boolean.valueOf(this.checkKeepFormatting.isSelected()));
        if (this.comboDefinitions.getSelectedItem() != null) {
            CopyCodeDefinition cc = (CopyCodeDefinition)this.comboDefinitions.getSelectedItem();
            this.settings.setValue("last-selected", cc.getName());
        }
        this.settings.setValue("dialog-width", new Variant(this.getWidth()));
        this.settings.setValue("dialog-height", new Variant(this.getHeight()));
        this.settings.store();
        super.dispose();
    }

    private DocumentListener getDocumentListener() {
        if (this.documentListener == null) {
            this.documentListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    if (CopyCodeDialog.this.isVisible()) {
                        CopyCodeDialog.this.updateResultText();
                    }
                }

                public void removeUpdate(DocumentEvent e) {
                    if (CopyCodeDialog.this.isVisible()) {
                        CopyCodeDialog.this.updateResultText();
                    }
                }

                public void changedUpdate(DocumentEvent e) {
                }
            };
        }
        return this.documentListener;
    }

    private void updateResultText() {
        if (this.groupUpdate) {
            return;
        }
        String beforeChars = this.textBeforeChars.getText();
        StringList sl = new StringList();
        if ("".equals(this.textParamAs.getText())) {
            sl.setText(this.syntaxSource.getText());
        } else {
            ParameterList pl = new ParameterList();
            try {
                sl.setText(pl.parseParameters(this.syntaxSource.getText(), this.textParamAs.getText()));
            }
            catch (UseDBException ex) {
                sl.setText(ex.getMessage());
                ExceptionUtil.processException((Throwable)ex);
                return;
            }
        }
        StringBuilder newLine = new StringBuilder();
        for (int i = 0; i < sl.size(); ++i) {
            newLine.setLength(0);
            String line = (String)sl.get(i);
            int spaceCount = 0;
            if (this.checkTrimSpaceBars.isSelected()) {
                if (this.checkKeepFormatting.isSelected()) {
                    spaceCount = line.length() - line.trim().length();
                }
                line = line.trim();
            }
            for (int c = 0; c < line.length(); ++c) {
                char ch = line.charAt(c);
                if (beforeChars.indexOf(ch) >= 0) {
                    newLine.append(this.textChars.getText());
                }
                newLine.append(ch);
            }
            line = this.textAddBefore.getText() + newLine.toString() + (i == sl.size() - 1 ? this.textEndLast.getText() : this.textAddAfter.getText());
            if (spaceCount > 0) {
                line = String.format("%1$" + spaceCount + "s", " ") + line;
            }
            sl.set(i, (Object)line);
        }
        if (this.textBeforeAll.getText().length() > 0) {
            sl.add(0, (Object)this.textBeforeAll.getText());
        }
        if (this.textAfterAll.getText().length() > 0) {
            sl.add((Object)this.textAfterAll.getText());
        }
        this.textResult.setText(sl.getText());
    }

    private void initComponents() {
        this.cmCancel = new Action();
        this.cmCopy = new Action();
        this.cmNewSet = new Action();
        this.cmDeleteSet = new Action();
        this.cmUpdateSet = new Action();
        this.cmUpdateText = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.comboDefinitions = new JComboBox();
        this.buttonNew = new JButton();
        this.buttonDelete = new JButton();
        this.buttonUpdate = new JButton();
        this.checkTrimSpaceBars = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.textAddBefore = new TextField();
        this.jLabel3 = new JLabel();
        this.textAddAfter = new TextField();
        this.jLabel4 = new JLabel();
        this.textEndLast = new TextField();
        this.jLabel5 = new JLabel();
        this.textBeforeChars = new TextField();
        this.jLabel6 = new JLabel();
        this.textChars = new TextField();
        this.syntaxSource = new OrbadaSyntaxTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.textResult = new JTextArea();
        this.jLabel7 = new JLabel();
        this.textBeforeAll = new TextField();
        this.jLabel9 = new JLabel();
        this.textParamAs = new TextField();
        this.jLabel8 = new JLabel();
        this.textAfterAll = new TextField();
        this.checkKeepFormatting = new JCheckBox();
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CopyCodeDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmCopy.setActionCommandKey("cmCopy");
        this.cmCopy.setText(this.stringManager.getString("cmCopy-text"));
        this.cmCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CopyCodeDialog.this.cmCopyActionPerformed(evt);
            }
        });
        this.cmNewSet.setText(this.stringManager.getString("cmNewSet-text"));
        this.cmNewSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CopyCodeDialog.this.cmNewSetActionPerformed(evt);
            }
        });
        this.cmDeleteSet.setText(this.stringManager.getString("cmDeleteSet-text"));
        this.cmDeleteSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CopyCodeDialog.this.cmDeleteSetActionPerformed(evt);
            }
        });
        this.cmUpdateSet.setText(this.stringManager.getString("cmUpdateSet-text"));
        this.cmUpdateSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CopyCodeDialog.this.cmUpdateSetActionPerformed(evt);
            }
        });
        this.cmUpdateText.setText(this.stringManager.getString("cmUpdateText-text"));
        this.cmUpdateText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CopyCodeDialog.this.cmUpdateTextActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("CopyCodeDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmCopy);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 24));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 24));
        this.jLabel1.setText(this.stringManager.getString("defined-settings-dd"));
        this.comboDefinitions.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CopyCodeDialog.this.comboDefinitionsItemStateChanged(evt);
            }
        });
        this.buttonNew.setAction((javax.swing.Action)this.cmNewSet);
        this.buttonNew.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNew.setPreferredSize(new Dimension(85, 24));
        this.buttonDelete.setAction((javax.swing.Action)this.cmDeleteSet);
        this.buttonDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDelete.setPreferredSize(new Dimension(85, 24));
        this.buttonUpdate.setAction((javax.swing.Action)this.cmUpdateSet);
        this.buttonUpdate.setMargin(new Insets(2, 2, 2, 2));
        this.buttonUpdate.setPreferredSize(new Dimension(85, 24));
        this.checkTrimSpaceBars.setText(this.stringManager.getString("remove-extra-spaces"));
        this.checkTrimSpaceBars.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkTrimSpaceBars.setMargin(new Insets(0, 0, 0, 0));
        this.checkTrimSpaceBars.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CopyCodeDialog.this.checkTrimSpaceBarsItemStateChanged(evt);
            }
        });
        this.checkTrimSpaceBars.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CopyCodeDialog.this.checkTrimSpaceBarsActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(this.stringManager.getString("for-each-line")));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("add-before-dd"));
        this.textAddBefore.setText("  \"");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("add-after-dd"));
        this.textAddAfter.setText("\\n\" +");
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("finish-last-dd"));
        this.textEndLast.setText("\";");
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("precede-characters-dd"));
        this.textBeforeChars.setText("\"\\");
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("with-char-dd"));
        this.textChars.setText("\\");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textAddBefore, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textBeforeChars, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textChars, -2, 74, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textAddAfter, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textEndLast, -2, 74, -2))).addContainerGap(291, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textAddBefore, -2, -1, -2).addComponent(this.jLabel5).addComponent((Component)this.textBeforeChars, -2, -1, -2).addComponent(this.jLabel6).addComponent((Component)this.textChars, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textAddAfter, -2, -1, -2).addComponent(this.jLabel4).addComponent((Component)this.textEndLast, -2, -1, -2))));
        this.syntaxSource.setEditable(false);
        this.textResult.setColumns(20);
        this.textResult.setEditable(false);
        this.textResult.setFont(new Font("Courier New", 0, 11));
        this.textResult.setRows(5);
        this.jScrollPane1.setViewportView(this.textResult);
        this.jLabel7.setText(this.stringManager.getString("add-before-lines-dd"));
        this.jLabel9.setText(this.stringManager.getString("named-params-replace-by-dd"));
        this.jLabel8.setText(this.stringManager.getString("add-after-lines-dd"));
        this.checkKeepFormatting.setText(this.stringManager.getString("keep-formatting"));
        this.checkKeepFormatting.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CopyCodeDialog.this.checkKeepFormattingItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addComponent((Component)this.syntaxSource, -2, 302, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 457, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textBeforeAll, -2, 346, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textParamAs, -2, 145, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboDefinitions, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.buttonNew, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonUpdate, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDelete, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 412, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonOk, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.buttonCancel, -2, -1, -2)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textAfterAll, -2, 346, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkTrimSpaceBars).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkKeepFormatting))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.comboDefinitions, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonNew, -2, -1, -2).addComponent(this.buttonUpdate, -2, -1, -2).addComponent(this.buttonDelete, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.textBeforeAll, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.jLabel9).addComponent((Component)this.textParamAs, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent((Component)this.textAfterAll, -2, -1, -2).addComponent(this.checkTrimSpaceBars).addComponent(this.checkKeepFormatting)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 261, Short.MAX_VALUE).addComponent((Component)this.syntaxSource, -1, 261, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void cmUpdateTextActionPerformed(ActionEvent evt) {
        this.updateResultText();
    }

    private void cmDeleteSetActionPerformed(ActionEvent evt) {
        CopyCodeDefinition cc;
        if (this.comboDefinitions.getSelectedItem() != null && (cc = (CopyCodeDefinition)this.comboDefinitions.getSelectedItem()).isUpdatable() && MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("CopyCodeDialog-delete-def-q"), cc.getName()), (int[])ModalResult.YESNO) == 5) {
            this.comboDefinitions.removeItem(cc);
        }
    }

    private void cmUpdateSetActionPerformed(ActionEvent evt) {
        CopyCodeDefinition cc;
        if (this.comboDefinitions.getSelectedItem() != null && (cc = (CopyCodeDefinition)this.comboDefinitions.getSelectedItem()).isUpdatable()) {
            cc.setBeforeAll(this.textBeforeAll.getText());
            cc.setAfterAll(this.textAfterAll.getText());
            cc.setAddBefore(this.textAddBefore.getText());
            cc.setAddAfter(this.textAddAfter.getText());
            cc.setEndLast(this.textEndLast.getText());
            cc.setBeforeChars(this.textBeforeChars.getText());
            cc.setChars(this.textChars.getText());
            cc.setParamAs(this.textParamAs.getText());
        }
    }

    private void cmNewSetActionPerformed(ActionEvent evt) {
        String name = JOptionPane.showInputDialog(this, (Object)this.stringManager.getString("input-name-dd"));
        if (name != null) {
            CopyCodeDefinition cc = new CopyCodeDefinition(name);
            cc.setBeforeAll(this.textBeforeAll.getText());
            cc.setAfterAll(this.textAfterAll.getText());
            cc.setAddBefore(this.textAddBefore.getText());
            cc.setAddAfter(this.textAddAfter.getText());
            cc.setEndLast(this.textEndLast.getText());
            cc.setBeforeChars(this.textBeforeChars.getText());
            cc.setChars(this.textChars.getText());
            cc.setParamAs(this.textParamAs.getText());
            this.comboDefinitions.addItem(cc);
            this.comboDefinitions.setSelectedItem(cc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comboDefinitionsItemStateChanged(ItemEvent evt) {
        this.groupUpdate = true;
        try {
            if (this.comboDefinitions.getSelectedItem() != null) {
                CopyCodeDefinition cc = (CopyCodeDefinition)this.comboDefinitions.getSelectedItem();
                this.cmDeleteSet.setEnabled(cc.isUpdatable());
                this.cmUpdateSet.setEnabled(cc.isUpdatable());
                this.textBeforeAll.setText(cc.getBeforeAll());
                this.textAfterAll.setText(cc.getAfterAll());
                this.textAddBefore.setText(cc.getAddBefore());
                this.textAddAfter.setText(cc.getAddAfter());
                this.textEndLast.setText(cc.getEndLast());
                this.textBeforeChars.setText(cc.getBeforeChars());
                this.textChars.setText(cc.getChars());
                this.textParamAs.setText(cc.getParamAs());
            } else {
                this.cmDeleteSet.setEnabled(false);
                this.textBeforeAll.setText("");
                this.textAfterAll.setText("");
                this.textAddBefore.setText("");
                this.textAddAfter.setText("");
                this.textEndLast.setText("");
                this.textBeforeChars.setText("");
                this.textChars.setText("");
                this.textParamAs.setText("");
            }
        }
        finally {
            this.groupUpdate = false;
            this.updateResultText();
        }
    }

    private void cmCopyActionPerformed(ActionEvent evt) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(this.textResult.getText());
        clipboard.setContents(data, data);
        this.dispose();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void checkTrimSpaceBarsItemStateChanged(ItemEvent evt) {
        if (this.isVisible()) {
            this.updateResultText();
        }
    }

    private void checkTrimSpaceBarsActionPerformed(ActionEvent evt) {
        this.checkKeepFormatting.setEnabled(this.checkTrimSpaceBars.isSelected());
    }

    private void checkKeepFormattingItemStateChanged(ItemEvent evt) {
        if (this.isVisible()) {
            this.updateResultText();
        }
    }
}

