/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.programmers.gui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.programmers.OrbadaProgrammersPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.DatabaseManager;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DatabaseUserPropertiesDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaProgrammersPlugin.class);
    private JButton buttonCancel;
    private Action cmClose;
    private JScrollPane jScrollPane1;
    private JTextArea textResolvers;

    public DatabaseUserPropertiesDialog() {
        super(SwingUtil.getRootFrame());
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DatabaseUserPropertiesDialog dialog = new DatabaseUserPropertiesDialog();
                dialog.setVisible(true);
            }
        });
    }

    private void init() {
        for (Database database : DatabaseManager.getManager().getDatabaseList(null, null)) {
            this.textResolvers.append(database.getPublicName() + " - " + database.getUrl() + "\n");
            Enumeration<?> e = database.getUserProperties().propertyNames();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                this.textResolvers.append("  " + o.toString() + " = <" + database.getUserProperties().getProperty(o.toString()) + ">\n");
            }
            this.textResolvers.append("\n");
        }
        Font font = this.textResolvers.getFont();
        this.textResolvers.setFont(new Font(font.getFamily(), font.getStyle(), 12));
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmClose);
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void initComponents() {
        this.cmClose = new Action();
        this.buttonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.textResolvers = new JTextArea();
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(this.stringManager.getString("cmClose-text"));
        this.cmClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatabaseUserPropertiesDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("DatabaseUserPropertiesDialog-title"));
        this.setModal(true);
        this.buttonCancel.setAction((javax.swing.Action)this.cmClose);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.textResolvers.setColumns(20);
        this.textResolvers.setEditable(false);
        this.textResolvers.setRows(5);
        this.jScrollPane1.setViewportView(this.textResolvers);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonCancel, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jScrollPane1, -1, 620, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 329, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

