/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.todo;

import java.io.File;
import java.util.List;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.plugins.OrbadaPlugin;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.todo.services.TodoPerspectiveProvider;
import pl.mpak.orbada.todo.services.TodoView;
import pl.mpak.plugins.spi.IPlugin;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.VersionID;
import pl.mpak.util.patt.Resolvers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbadaTodoPlugin
extends OrbadaPlugin {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaTodoPlugin.class);
    public static final String todoGroupName = "Orbada Tools";

    public String getInternalName() {
        return "OrbadaTodoPlugin";
    }

    public String getDescriptiveName() {
        return String.format(this.stringManager.getString("OrbadaTodoPlugin-descriptive-name"), this.getVersion());
    }

    public String getDescription() {
        return "";
    }

    public String getCategory() {
        return "IDE,Developers";
    }

    public String getAuthor() {
        return "Andrzej Ka\u0142u\u017ca";
    }

    public String getCopyrights() {
        return "";
    }

    public String getWebSite() {
        return null;
    }

    public String getUpdateSite() {
        return null;
    }

    public String getVersion() {
        return new VersionID(1, 0, 2, 24).toString();
    }

    public String getLicence() {
        return null;
    }

    public String getUniqueID() {
        return "orbada-todo-plugin";
    }

    public void load() {
    }

    public void unload() {
    }

    public void initialize() {
        new File(Resolvers.expand((String)"$(orbada.home)") + "/todos").mkdirs();
        if (this.application.isUserAdmin()) {
            Database database = InternalDatabase.get();
            if (this.getLastVersion() == null) {
                try {
                    database.executeCommand("create table todos (\n  td_id varchar(40) not null primary key,\n  td_usr_id varchar(40) not null,\n  td_sch_id varchar(40),\n  td_priority integer,\n  td_state varchar(100),\n  td_title varchar(200),\n  td_description varchar(1000),\n  td_enable varchar(1) default 'T',\n  td_inserted timestamp,\n  td_updated timestamp,\n  td_workaround varchar(1000),\n  td_plan_end timestamp,\n  td_ended timestamp,\n  td_app_version varchar(100),\n  td_orbada varchar(1),\n  td_exported varchar(1)\n)");
                    database.executeCommand("alter table todos add constraint todos_sch_id_fk foreign key (td_sch_id) references schemas (sch_id) on delete cascade");
                    database.executeCommand("create index todos_sch_id_priority_i on todos (td_sch_id, td_priority)");
                    database.executeCommand("alter table todos add constraint todo_user_fk foreign key (td_usr_id) references users (usr_id) on delete cascade");
                }
                catch (Exception ex2) {
                    ExceptionUtil.processException((Throwable)ex2);
                }
            } else if (new VersionID(this.getLastVersion()).getBuild() < 21) {
                try {
                    database.executeCommand("alter table todos add td_app_version varchar(100)");
                    database.executeCommand("alter table todos add td_orbada varchar(1)");
                    database.executeCommand("alter table todos add td_exported varchar(1)");
                }
                catch (Exception ex2) {
                    ExceptionUtil.processException((Throwable)ex2);
                }
            }
        }
    }

    public boolean requires(List<IPlugin> loadedPlugins) {
        return true;
    }

    public Class<IPluginProvider>[] getProviderArray() {
        return new Class[]{TodoView.class, TodoPerspectiveProvider.class};
    }

    public void processMessage(PluginMessage message) {
    }
}

