/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.todo.db;

import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringUtil;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;

public class Todo
extends BufferedRecord {
    public Todo() {
        super("TODOS", "TD_ID");
        this.add("TD_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("TD_USR_ID", new Variant(Application.get().getUserId()), 11, true);
        this.add("TD_SCH_ID", 11, true);
        this.add("TD_PRIORITY", 6, true);
        this.add("TD_STATE", 11, true);
        this.add("TD_TITLE", 11, true);
        this.add("TD_DESCRIPTION", 11, true);
        this.add("TD_ENABLE", 11, true);
        this.add("TD_INSERTED", 20, true);
        this.add("TD_UPDATED", 20, true);
        this.add("TD_WORKAROUND", 11, true);
        this.add("TD_PLAN_END", 20, true);
        this.add("TD_ENDED", 20, true);
        this.add("TD_APP_VERSION", 11, true);
        this.add("TD_ORBADA", 11, true);
        this.add("TD_EXPORTED", 11, true);
    }

    public Todo(String td_id) throws UseDBException {
        this();
        this.load(td_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(String td_id) throws UseDBException {
        this.cancelUpdates();
        Query query = new Query(InternalDatabase.get());
        query.setSqlText("select * from todos where td_id = :td_id");
        query.paramByName("td_id").setString(td_id);
        try {
            query.open();
        }
        catch (Exception ex) {
            throw new UseDBException((Throwable)ex);
        }
        try {
            if (!query.eof()) {
                this.updateFrom(query);
            }
        }
        finally {
            query.close();
        }
    }

    public void applyInsert() throws Exception {
        if (!this.fieldByName("TD_INSERTED").isChanged()) {
            this.fieldByName("TD_INSERTED").setValue(new Variant(System.currentTimeMillis()));
        }
        if (!this.fieldByName("TD_UPDATED").isChanged()) {
            this.fieldByName("TD_UPDATED").setLong(System.currentTimeMillis());
        }
        if (StringUtil.toBoolean((String)this.fieldByName("TD_ORBADA").getString()) && !"20080808194053-00000D1B617B0B5A-EBA871AB".equals(this.fieldByName("TD_USR_ID").getString())) {
            this.fieldByName("TD_SCH_ID").setValue(null);
            this.fieldByName("TD_USR_ID").setString("20080808194053-00000D1B617B0B5A-EBA871AB");
        }
        Command command = this.insertCommand(InternalDatabase.get());
        command.execute();
    }

    public void applyUpdate() throws Exception {
        if (!this.fieldByName("TD_UPDATED").isChanged()) {
            this.fieldByName("TD_UPDATED").setLong(System.currentTimeMillis());
        }
        if (!StringUtil.toBoolean((String)this.fieldByName("TD_ENABLE").getString()) && this.fieldByName("TD_ENABLE").getOldValue() != null && StringUtil.toBoolean((String)this.fieldByName("TD_ENABLE").getOldValue().getString())) {
            this.fieldByName("TD_ENDED").setLong(System.currentTimeMillis());
        } else if (StringUtil.toBoolean((String)this.fieldByName("TD_ENABLE").getString())) {
            this.fieldByName("TD_ENDED").setValue(null);
        }
        Command command = this.updateCommand(InternalDatabase.get());
        command.execute();
    }

    public void applyDelete() throws Exception {
        Command command = this.deleteCommand(InternalDatabase.get());
        command.execute();
    }
}

