/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.todo.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.todo.OrbadaTodoPlugin;
import pl.mpak.orbada.todo.db.Todo;
import pl.mpak.orbada.todo.gui.ImportTodoItem;
import pl.mpak.orbada.todo.gui.ImportTodoTableModel;
import pl.mpak.orbada.todo.gui.TodoEditDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.patt.Resolvers;

public class ImportTodoDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaTodoPlugin.class);
    private int modalResult = 0;
    private File[] files;
    private ArrayList<ImportTodoItem> list;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JButton buttonView;
    private Action cmCancel;
    private Action cmOk;
    private Action cmView;
    private JScrollPane jScrollPane1;
    private Table tableTodos;

    public ImportTodoDialog(File[] files) {
        this.initComponents();
        this.list = new ArrayList();
        this.files = files;
        this.init();
    }

    public static boolean showDialog() {
        File[] files = FileUtil.selectFilesToOpen((Component)Application.get().getMainFrame(), (String)stringManager.getString("opening-todo"), (String)(Resolvers.expand((String)"$(orbada.home)") + "/todos"), (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(stringManager.getString("todo-files"), new String[]{".xml.todo"})});
        if (files != null) {
            ImportTodoDialog dialog = new ImportTodoDialog(files);
            dialog.setVisible(true);
            return dialog.modalResult == 1;
        }
        return false;
    }

    private TableColumn createTableColumn(int columnIndex, int width, String title, TableCellRenderer renderer) {
        TableColumn column = new TableColumn(columnIndex, width, renderer, null);
        column.setHeaderValue(title);
        return column;
    }

    private void init() {
        this.setSize(600, 350);
        for (File file : this.files) {
            try {
                Todo newTodo = new Todo();
                newTodo.loadFromXML(new FileInputStream(file));
                this.list.add(new ImportTodoItem(newTodo));
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.tableTodos.setSelectionMode(0);
        this.tableTodos.setModel((TableModel)new ImportTodoTableModel(this.list.toArray(new ImportTodoItem[this.list.size()])));
        this.tableTodos.setColumnModel((TableColumnModel)new DefaultTableColumnModel());
        this.tableTodos.getColumnModel().addColumn(this.createTableColumn(0, 30, stringManager.getString("imp"), null));
        this.tableTodos.getColumnModel().addColumn(this.createTableColumn(1, 30, stringManager.getString("act"), new DefaultTableCellRenderer()));
        this.tableTodos.getColumnModel().addColumn(this.createTableColumn(2, 400, stringManager.getString("task"), new DefaultTableCellRenderer()));
        this.tableTodos.getColumnModel().addColumn(this.createTableColumn(3, 120, stringManager.getString("updated"), new DefaultTableCellRenderer()));
        this.tableTodos.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ImportTodoDialog.this.cmView.setEnabled(e.getFirstIndex() >= 0);
            }
        });
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
    }

    public void dispose() {
        super.dispose();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.cmView = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableTodos = new Table();
        this.buttonView = new JButton();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportTodoDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportTodoDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmView.setEnabled(false);
        this.cmView.setText(stringManager.getString("cmView-text"));
        this.cmView.setTooltip(stringManager.getString("cmView-hint"));
        this.cmView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportTodoDialog.this.cmViewActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("ImportTodoDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.tableTodos.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView((Component)this.tableTodos);
        this.buttonView.setAction((javax.swing.Action)this.cmView);
        this.buttonView.setPreferredSize(new Dimension(75, 23));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonView, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 340, Short.MAX_VALUE).addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addComponent(this.jScrollPane1, -1, 571, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 310, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonView, -2, -1, -2)).addContainerGap()));
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.modalResult = 1;
            for (ImportTodoItem item : this.list) {
                item.updateTodo();
            }
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmViewActionPerformed(ActionEvent evt) {
        if (this.tableTodos.getSelectedRow() >= 0) {
            ImportTodoItem item = ((ImportTodoTableModel)this.tableTodos.getModel()).getItem(this.tableTodos.getSelectedRow());
            try {
                TodoEditDialog.showDialog(item.getNewTodo(), false);
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }
}

