/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.todo.gui;

import java.io.IOException;
import pl.mpak.orbada.todo.db.Todo;
import pl.mpak.usedb.UseDBException;
import pl.mpak.util.variant.VariantException;

public class ImportTodoItem {
    private Todo newTodo;
    private Todo todo;
    private boolean insert;
    private boolean update;
    private boolean importTodo;

    public ImportTodoItem(Todo newTodo) throws UseDBException, VariantException, IOException {
        this.newTodo = newTodo;
        this.todo = new Todo(newTodo.fieldByName("TD_ID").getString());
        this.insert = this.todo.fieldByName("TD_ID").isNull();
        this.update = !this.insert ? newTodo.fieldByName("TD_UPDATED").getLong() > this.todo.fieldByName("TD_UPDATED").getLong() : true;
        this.importTodo = this.insert || this.update;
    }

    public boolean isInsert() {
        return this.insert;
    }

    public Todo getNewTodo() {
        return this.newTodo;
    }

    public Todo getTodo() {
        return this.todo;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public boolean isImportTodo() {
        return this.importTodo;
    }

    public void setImportTodo(boolean importTodo) {
        this.importTodo = importTodo;
    }

    public void updateTodo() throws Exception {
        if (this.importTodo) {
            if (this.insert) {
                this.newTodo.applyInsert();
            } else if (this.update) {
                this.newTodo.applyUpdate();
            }
        }
    }
}

