/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.todo.gui;

import javax.swing.table.AbstractTableModel;
import pl.mpak.orbada.todo.OrbadaTodoPlugin;
import pl.mpak.orbada.todo.gui.ImportTodoItem;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ImportTodoTableModel
extends AbstractTableModel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaTodoPlugin.class);
    private ImportTodoItem[] items;

    public ImportTodoTableModel(ImportTodoItem[] items) {
        this.items = items;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return this.stringManager.getString("imp");
            }
            case 1: {
                return this.stringManager.getString("op");
            }
            case 2: {
                return this.stringManager.getString("title");
            }
            case 3: {
                return this.stringManager.getString("updated");
            }
        }
        return "???";
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    public int getRowCount() {
        return this.items.length;
    }

    public int getColumnCount() {
        return 0;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            switch (columnIndex) {
                case 0: {
                    return this.items[rowIndex].isImportTodo();
                }
                case 1: {
                    return this.items[rowIndex].isInsert() ? this.stringManager.getString("new") : this.stringManager.getString("act");
                }
                case 2: {
                    return this.items[rowIndex].getNewTodo().fieldByName("TD_TITLE").getString();
                }
                case 3: {
                    return this.items[rowIndex].getNewTodo().fieldByName("TD_UPDATED").getString();
                }
            }
            return "???";
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            this.items[rowIndex].setImportTodo((Boolean)aValue);
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public ImportTodoItem getItem(int rowIndex) {
        return this.items[rowIndex];
    }
}

