/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.todo.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.todo.OrbadaTodoPlugin;
import pl.mpak.orbada.todo.db.Todo;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.FieldLinkType;
import pl.mpak.usedb.gui.RecordLink;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class TodoEditDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaTodoPlugin.class);
    private String td_id;
    private String td_sch_id;
    private int modalResult = 0;
    private Todo todo;
    private RecordLink driverLink;
    private boolean editable;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkTodoEnable;
    private JCheckBox checkTodoOrbada;
    private Action cmCancel;
    private Action cmOk;
    private JComboBox comboTodoState;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSpinner spinTodoPriority;
    private TextField textTodoAppVersion;
    private TextArea textTodoDescription;
    private TextField textTodoEnded;
    private TextField textTodoId;
    private TextField textTodoPlanEnd;
    private TextField textTodoTitle;
    private TextArea textTodoWorkoround;

    public TodoEditDialog(String td_id, String td_sch_id) throws IntrospectionException, UseDBException {
        this.td_id = td_id;
        this.td_sch_id = td_sch_id;
        this.editable = true;
        this.initComponents();
        this.init();
    }

    public TodoEditDialog(Todo todo, boolean editable) throws IntrospectionException, UseDBException {
        this.todo = todo;
        this.editable = editable;
        this.initComponents();
        this.init();
    }

    public static int showDialog(String td_id, String td_sch_id) throws IntrospectionException, UseDBException {
        TodoEditDialog dialog = new TodoEditDialog(td_id, td_sch_id);
        dialog.setVisible(true);
        return dialog.getModalResult();
    }

    public static int showDialog(Todo todo, boolean editable) throws IntrospectionException, UseDBException {
        TodoEditDialog dialog = new TodoEditDialog(todo, editable);
        dialog.setVisible(true);
        return dialog.getModalResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IntrospectionException, UseDBException {
        this.textTodoDescription.setFont(this.getFont());
        this.textTodoWorkoround.setFont(this.getFont());
        Query query = InternalDatabase.get().createQuery();
        try {
            try {
                query.open("select distinct td_state from todos order by td_state");
                this.comboTodoState.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray(null, (Query)query)));
            }
            catch (Exception e) {
                ExceptionUtil.processException((Throwable)e);
            }
        }
        finally {
            query.close();
        }
        this.driverLink = new RecordLink();
        this.driverLink.add("TD_TITLE", (Component)this.textTodoTitle);
        this.driverLink.add("TD_STATE", (Component)this.comboTodoState, "selectedItem");
        this.driverLink.add("TD_PRIORITY", (Component)this.spinTodoPriority, "value", 6);
        this.driverLink.add("TD_DESCRIPTION", (Component)this.textTodoDescription);
        this.driverLink.add("TD_ENABLE", (Component)this.checkTodoEnable, "selected", FieldLinkType.Boolean_TF);
        this.driverLink.add("TD_WORKAROUND", (Component)this.textTodoWorkoround);
        this.driverLink.add("TD_PLAN_END", (Component)this.textTodoPlanEnd);
        this.driverLink.add("TD_ENDED", (Component)this.textTodoEnded);
        this.driverLink.add("TD_APP_VERSION", (Component)this.textTodoAppVersion);
        this.driverLink.add("TD_ORBADA", (Component)this.checkTodoOrbada, "selected", FieldLinkType.Boolean_TF);
        if (this.todo == null) {
            if (this.td_id != null) {
                this.todo = new Todo(this.td_id);
            } else {
                this.todo = new Todo();
                this.todo.fieldByName("TD_SCH_ID").setValue(new Variant(this.td_sch_id));
                this.todo.fieldByName("TD_PRIORITY").setValue(new Variant(1));
                this.todo.fieldByName("TD_ENABLE").setValue(new Variant("T"));
            }
        }
        this.textTodoId.setText(this.todo.fieldByName("TD_ID").getValue().toString());
        this.driverLink.updateComponents((BufferedRecord)this.todo);
        this.cmOk.setEnabled(this.editable);
        this.textTodoTitle.setEnabled(this.editable);
        this.comboTodoState.setEnabled(this.editable);
        this.spinTodoPriority.setEnabled(this.editable);
        this.textTodoDescription.setEnabled(this.editable);
        this.checkTodoEnable.setEnabled(this.editable);
        this.textTodoWorkoround.setEnabled(this.editable);
        this.textTodoPlanEnd.setEnabled(this.editable);
        this.textTodoEnded.setEnabled(this.editable);
        this.textTodoAppVersion.setEnabled(this.editable);
        this.checkTodoOrbada.setEnabled(this.editable);
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void dispose() {
        super.dispose();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.textTodoTitle = new TextField();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.comboTodoState = new JComboBox();
        this.jLabel3 = new JLabel();
        this.spinTodoPriority = new JSpinner();
        this.jLabel4 = new JLabel();
        this.checkTodoEnable = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.textTodoDescription = new TextArea();
        this.jScrollPane2 = new JScrollPane();
        this.textTodoWorkoround = new TextArea();
        this.textTodoEnded = new TextField();
        this.jLabel6 = new JLabel();
        this.textTodoPlanEnd = new TextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.textTodoAppVersion = new TextField();
        this.checkTodoOrbada = new JCheckBox();
        this.textTodoId = new TextField();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TodoEditDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TodoEditDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("TodoEditDialog-title"));
        this.setModal(true);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setLabelFor((Component)this.textTodoTitle);
        this.jLabel1.setText(this.stringManager.getString("title-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("status-dd"));
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.comboTodoState.setEditable(true);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("priority-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("description-dd"));
        this.checkTodoEnable.setText(this.stringManager.getString("task-is-active"));
        this.checkTodoEnable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkTodoEnable.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("solution-dd"));
        this.textTodoDescription.setColumns(20);
        this.textTodoDescription.setLineWrap(true);
        this.textTodoDescription.setRows(5);
        this.jScrollPane1.setViewportView((Component)this.textTodoDescription);
        this.textTodoWorkoround.setColumns(20);
        this.textTodoWorkoround.setLineWrap(true);
        this.textTodoWorkoround.setRows(5);
        this.jScrollPane2.setViewportView((Component)this.textTodoWorkoround);
        this.textTodoEnded.setEditable(false);
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setLabelFor((Component)this.textTodoTitle);
        this.jLabel6.setText(this.stringManager.getString("planned-finish-dd"));
        this.jLabel7.setText("(yyyy-mm-dd hh:mm:ss)");
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setLabelFor((Component)this.textTodoTitle);
        this.jLabel8.setText(this.stringManager.getString("application-version-dd"));
        this.checkTodoOrbada.setText(this.stringManager.getString("the-notification-concerns-the-ORBADA"));
        this.checkTodoOrbada.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkTodoOrbada.setMargin(new Insets(0, 0, 0, 0));
        this.textTodoId.setEditable(false);
        this.textTodoId.setFocusable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 129, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 322, Short.MAX_VALUE).addComponent(this.spinTodoPriority, -2, 59, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent((Component)this.textTodoPlanEnd, -1, 201, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7)).addComponent(this.checkTodoOrbada).addComponent((Component)this.textTodoTitle, -1, 322, Short.MAX_VALUE).addComponent(this.comboTodoState, 0, 322, Short.MAX_VALUE).addComponent((Component)this.textTodoAppVersion, -1, 322, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 322, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.checkTodoEnable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textTodoEnded, -2, 145, -2)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent((Component)this.textTodoId, -1, 293, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textTodoTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTodoState, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.spinTodoPriority, -2, -1, -2)).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent((Component)this.textTodoPlanEnd, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent((Component)this.textTodoAppVersion, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkTodoOrbada).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jScrollPane1, -2, 87, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jScrollPane2, -1, 80, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkTodoEnable).addComponent((Component)this.textTodoEnded, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.buttonCancel, -2, -1, -2).addComponent((Component)this.textTodoId, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.driverLink.updateRecord((BufferedRecord)this.todo);
            if (this.todo.isChanged()) {
                if (this.td_id == null) {
                    this.todo.applyInsert();
                } else {
                    this.todo.applyUpdate();
                }
            }
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }
}

