/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.todo.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.todo.OrbadaTodoPlugin;
import pl.mpak.orbada.todo.db.Todo;
import pl.mpak.orbada.todo.gui.ImportTodoDialog;
import pl.mpak.orbada.todo.gui.TodoEditDialog;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.patt.Resolvers;
import pl.mpak.util.variant.Variant;

public class TodoPanelView
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaTodoPlugin.class);
    private IViewAccesibilities accesibilities;
    private String td_sch_id;
    private ToolButton buttonDelete;
    private ToolButton buttonDescPriority;
    private ToolButton buttonEdit;
    private ToolButton buttonExport;
    private ToolButton buttonImport;
    private ToolButton buttonIncPriority;
    private ToolButton buttonNew;
    private ToolButton buttonRefresh;
    private ToolButton buttonSwitchEnable;
    private Action cmDecPriority;
    private Action cmDeleteTask;
    private Action cmEditTask;
    private Action cmExportTodo;
    private Action cmImportTodo;
    private Action cmIncPriority;
    private Action cmNewTask;
    private Action cmRefresh;
    private Action cmSwitchEnableTask;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JToolBar.Separator jSeparator7;
    private JSeparator jSeparator8;
    private JToolBar jToolBar1;
    private JMenuItem menuDelete;
    private JMenuItem menuEdit;
    private JMenuItem menuExport;
    private JMenuItem menuImport;
    private JMenuItem menuNew;
    private JMenuItem menuRefresh;
    private JMenuItem menuSwitchEnable;
    private JMenu menuTodo;
    private QueryTableStatusBar queryTableStatusBar1;
    private ViewTable tableTodos;

    public TodoPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.menuTodo.setText(SwingUtil.setButtonText((AbstractButton)this.menuTodo, (String)this.stringManager.getString("TodoPanelView-menuTodo-text")));
        this.cmNewTask.setEnabled(false);
        this.cmEditTask.setEnabled(false);
        this.cmDeleteTask.setEnabled(false);
        this.cmSwitchEnableTask.setEnabled(false);
        this.accesibilities.addMenu(this.menuTodo);
        this.tableTodos.getQuery().setDatabase(InternalDatabase.get());
        this.tableTodos.getQuery().addQueryListener(new QueryListener(){

            public void beforeScroll(EventObject e) {
            }

            public void afterScroll(EventObject e) {
            }

            public void beforeOpen(EventObject e) {
            }

            public void afterOpen(EventObject e) {
                TodoPanelView.this.cmNewTask.setEnabled(true);
            }

            public void beforeClose(EventObject e) {
            }

            public void afterClose(EventObject e) {
                TodoPanelView.this.cmNewTask.setEnabled(false);
                TodoPanelView.this.cmEditTask.setEnabled(false);
                TodoPanelView.this.cmDeleteTask.setEnabled(false);
                TodoPanelView.this.cmSwitchEnableTask.setEnabled(false);
                TodoPanelView.this.cmIncPriority.setEnabled(false);
                TodoPanelView.this.cmDecPriority.setEnabled(false);
            }

            public void flushedPerformed(EventObject e) {
            }

            public void errorPerformed(EventObject e) {
            }
        });
        this.tableTodos.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TodoPanelView.this.cmEditTask.setEnabled(e.getFirstIndex() >= 0);
                TodoPanelView.this.cmDeleteTask.setEnabled(e.getFirstIndex() >= 0);
                TodoPanelView.this.cmSwitchEnableTask.setEnabled(e.getFirstIndex() >= 0);
                TodoPanelView.this.cmIncPriority.setEnabled(e.getFirstIndex() >= 0);
                TodoPanelView.this.cmDecPriority.setEnabled(e.getFirstIndex() >= 0);
                TodoPanelView.this.cmExportTodo.setEnabled(e.getFirstIndex() >= 0);
                TodoPanelView.this.cmImportTodo.setEnabled(true);
            }
        });
        try {
            QueryTableCellRenderer renderer = new QueryTableCellRenderer(){
                {
                    this.setShowNullValue(false);
                }

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    try {
                        if ("F".equals(TodoPanelView.this.tableTodos.getQuery().fieldByName("td_enable").getString())) {
                            label.setForeground(Color.DARK_GRAY);
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    return label;
                }
            };
            if (this.accesibilities.getDatabase() != null) {
                this.td_sch_id = this.accesibilities.getDatabase().getUserProperties().getProperty("schemaId");
            }
            this.tableTodos.addColumn((TableColumn)new QueryTableColumn("usr_name", this.stringManager.getString("user-name"), 80, (TableCellRenderer)renderer));
            this.tableTodos.addColumn((TableColumn)new QueryTableColumn("td_inserted", this.stringManager.getString("inserted"), 110, (TableCellRenderer)renderer));
            this.tableTodos.addColumn((TableColumn)new QueryTableColumn("td_updated", this.stringManager.getString("updated"), 110, (TableCellRenderer)renderer));
            if (this.td_sch_id == null) {
                this.tableTodos.addColumn((TableColumn)new QueryTableColumn("sch_name", this.stringManager.getString("schema"), 140, (TableCellRenderer)renderer));
            }
            this.tableTodos.addColumn((TableColumn)new QueryTableColumn("td_title", this.stringManager.getString("title"), 200, (TableCellRenderer)renderer));
            this.tableTodos.addColumn((TableColumn)new QueryTableColumn("td_priority", this.stringManager.getString("priority"), 50, (TableCellRenderer)renderer));
            this.tableTodos.addColumn((TableColumn)new QueryTableColumn("td_state", this.stringManager.getString("status"), 150, (TableCellRenderer)renderer));
            this.tableTodos.addColumn((TableColumn)new QueryTableColumn("td_description", this.stringManager.getString("description"), 600, (TableCellRenderer)renderer));
            if (this.td_sch_id == null) {
                this.tableTodos.getQuery().setSqlText("select todos.*, sch_name, usr_name from todos left outer join schemas on (td_sch_id = sch_id) left outer join users on (td_usr_id = usr_id) where (td_usr_id = :td_usr_id or usr_orbada = 'Y') order by td_enable desc, usr_orbada, td_priority, td_state");
                this.tableTodos.getQuery().paramByName("td_usr_id").setString(this.accesibilities.getApplication().getUserId());
            } else {
                this.tableTodos.getQuery().setSqlText("select todos.*, usr_name from todos left outer join users on (td_usr_id = usr_id) where (td_sch_id = :td_sch_id or usr_orbada = 'Y') order by td_enable desc, usr_orbada, td_priority, td_state");
                this.tableTodos.getQuery().paramByName("td_sch_id").setString(this.td_sch_id);
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    try {
                        TodoPanelView.this.tableTodos.getQuery().open();
                        if (!TodoPanelView.this.tableTodos.getQuery().isEmpty()) {
                            TodoPanelView.this.tableTodos.changeSelection(0, 0, false, false);
                        }
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            });
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void close() throws IOException {
        this.tableTodos.getQuery().close();
        this.accesibilities = null;
    }

    public void refreshQuery() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int lastRow = TodoPanelView.this.tableTodos.getSelectedRow();
                try {
                    String td_id = null;
                    if (TodoPanelView.this.tableTodos.getQuery().isActive() && lastRow != -1) {
                        TodoPanelView.this.tableTodos.getQuery().getRecord(lastRow);
                        td_id = TodoPanelView.this.tableTodos.getQuery().fieldByName("td_id").getString();
                    }
                    TodoPanelView.this.tableTodos.getQuery().refresh();
                    if (td_id != null && TodoPanelView.this.tableTodos.getQuery().locate("td_id", new Variant(td_id))) {
                        TodoPanelView.this.tableTodos.changeSelection(TodoPanelView.this.tableTodos.getQuery().getCurrentRecord().getIndex(), TodoPanelView.this.tableTodos.getSelectedColumn(), false, false);
                        lastRow = -1;
                    }
                    if (lastRow != -1) {
                        if (TodoPanelView.this.tableTodos.getRowCount() > lastRow && lastRow >= 0) {
                            TodoPanelView.this.tableTodos.setRowSelectionInterval(lastRow, lastRow);
                        } else if (TodoPanelView.this.tableTodos.getRowCount() > 0) {
                            TodoPanelView.this.tableTodos.setRowSelectionInterval(0, 0);
                        }
                    }
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        });
    }

    private void initComponents() {
        this.cmNewTask = new Action();
        this.cmEditTask = new Action();
        this.cmDeleteTask = new Action();
        this.cmSwitchEnableTask = new Action();
        this.cmRefresh = new Action();
        this.menuTodo = new JMenu();
        this.menuRefresh = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.menuNew = new JMenuItem();
        this.menuEdit = new JMenuItem();
        this.jSeparator8 = new JSeparator();
        this.menuExport = new JMenuItem();
        this.menuImport = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.menuSwitchEnable = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        this.menuDelete = new JMenuItem();
        this.cmIncPriority = new Action();
        this.cmDecPriority = new Action();
        this.cmExportTodo = new Action();
        this.cmImportTodo = new Action();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.jSeparator3 = new JSeparator();
        this.buttonNew = new ToolButton();
        this.buttonEdit = new ToolButton();
        this.jSeparator7 = new JToolBar.Separator();
        this.buttonExport = new ToolButton();
        this.buttonImport = new ToolButton();
        this.jSeparator2 = new JSeparator();
        this.buttonSwitchEnable = new ToolButton();
        this.buttonIncPriority = new ToolButton();
        this.buttonDescPriority = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonDelete = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableTodos = new ViewTable();
        this.queryTableStatusBar1 = new QueryTableStatusBar();
        this.cmNewTask.setActionCommandKey("cmNewTask");
        this.cmNewTask.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/new16.gif")));
        this.cmNewTask.setText(this.stringManager.getString("cmNewTask-text"));
        this.cmNewTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TodoPanelView.this.cmNewTaskActionPerformed(evt);
            }
        });
        this.cmEditTask.setActionCommandKey("cmEditTask");
        this.cmEditTask.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/edit16.gif")));
        this.cmEditTask.setText(this.stringManager.getString("cmEditTask-text"));
        this.cmEditTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TodoPanelView.this.cmEditTaskActionPerformed(evt);
            }
        });
        this.cmDeleteTask.setActionCommandKey("cmDeleteTask");
        this.cmDeleteTask.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/trash.gif")));
        this.cmDeleteTask.setText(this.stringManager.getString("cmDeleteTask-text"));
        this.cmDeleteTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TodoPanelView.this.cmDeleteTaskActionPerformed(evt);
            }
        });
        this.cmSwitchEnableTask.setActionCommandKey("cmSwitchEnable");
        this.cmSwitchEnableTask.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/enabled.gif")));
        this.cmSwitchEnableTask.setText(this.stringManager.getString("cmSwitchEnableTask-text"));
        this.cmSwitchEnableTask.setTooltip(this.stringManager.getString("cmSwitchEnableTask-hint"));
        this.cmSwitchEnableTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TodoPanelView.this.cmSwitchEnableTaskActionPerformed(evt);
            }
        });
        this.cmRefresh.setActionCommandKey("cmRefresh");
        this.cmRefresh.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/refresh16.gif")));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TodoPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.menuRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.menuTodo.add(this.menuRefresh);
        this.menuTodo.add(this.jSeparator4);
        this.menuNew.setAction((javax.swing.Action)this.cmNewTask);
        this.menuTodo.add(this.menuNew);
        this.menuEdit.setAction((javax.swing.Action)this.cmEditTask);
        this.menuTodo.add(this.menuEdit);
        this.menuTodo.add(this.jSeparator8);
        this.menuExport.setAction((javax.swing.Action)this.cmExportTodo);
        this.menuTodo.add(this.menuExport);
        this.menuImport.setAction((javax.swing.Action)this.cmImportTodo);
        this.menuTodo.add(this.menuImport);
        this.menuTodo.add(this.jSeparator5);
        this.menuSwitchEnable.setAction((javax.swing.Action)this.cmSwitchEnableTask);
        this.menuTodo.add(this.menuSwitchEnable);
        this.menuTodo.add(this.jSeparator6);
        this.menuDelete.setAction((javax.swing.Action)this.cmDeleteTask);
        this.menuTodo.add(this.menuDelete);
        this.cmIncPriority.setActionCommandKey("cmIncPriority");
        this.cmIncPriority.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/arrowup.gif")));
        this.cmIncPriority.setText(this.stringManager.getString("cmIncPriority-text"));
        this.cmIncPriority.setTooltip(this.stringManager.getString("cmIncPriority-hint"));
        this.cmIncPriority.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TodoPanelView.this.cmIncPriorityActionPerformed(evt);
            }
        });
        this.cmDecPriority.setActionCommandKey("cmDecPriority");
        this.cmDecPriority.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/arrowdown.gif")));
        this.cmDecPriority.setText(this.stringManager.getString("cmDecPriority-text"));
        this.cmDecPriority.setTooltip(this.stringManager.getString("cmDecPriority-hint"));
        this.cmDecPriority.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TodoPanelView.this.cmDecPriorityActionPerformed(evt);
            }
        });
        this.cmExportTodo.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/export_table16.gif")));
        this.cmExportTodo.setText(this.stringManager.getString("cmExportTodo-text"));
        this.cmExportTodo.setTooltip(this.stringManager.getString("cmExportTodo-hint"));
        this.cmExportTodo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TodoPanelView.this.cmExportTodoActionPerformed(evt);
            }
        });
        this.cmImportTodo.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/import_table16.gif")));
        this.cmImportTodo.setText(this.stringManager.getString("cmImportTodo-text"));
        this.cmImportTodo.setTooltip(this.stringManager.getString("cmImportTodo-hint"));
        this.cmImportTodo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TodoPanelView.this.cmImportTodoActionPerformed(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonRefresh);
        this.jSeparator3.setOrientation(1);
        this.jToolBar1.add(this.jSeparator3);
        this.buttonNew.setAction((javax.swing.Action)this.cmNewTask);
        this.buttonNew.setHorizontalTextPosition(0);
        this.buttonNew.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonNew);
        this.buttonEdit.setAction((javax.swing.Action)this.cmEditTask);
        this.buttonEdit.setHorizontalTextPosition(0);
        this.buttonEdit.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonEdit);
        this.jToolBar1.add(this.jSeparator7);
        this.buttonExport.setAction((javax.swing.Action)this.cmExportTodo);
        this.buttonExport.setHorizontalTextPosition(0);
        this.buttonExport.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonExport);
        this.buttonImport.setAction((javax.swing.Action)this.cmImportTodo);
        this.buttonImport.setHorizontalTextPosition(0);
        this.buttonImport.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonImport);
        this.jSeparator2.setOrientation(1);
        this.jToolBar1.add(this.jSeparator2);
        this.buttonSwitchEnable.setAction((javax.swing.Action)this.cmSwitchEnableTask);
        this.buttonSwitchEnable.setHorizontalTextPosition(0);
        this.buttonSwitchEnable.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonSwitchEnable);
        this.buttonIncPriority.setAction((javax.swing.Action)this.cmIncPriority);
        this.buttonIncPriority.setHorizontalTextPosition(0);
        this.buttonIncPriority.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonIncPriority);
        this.buttonDescPriority.setAction((javax.swing.Action)this.cmDecPriority);
        this.buttonDescPriority.setHorizontalTextPosition(0);
        this.buttonDescPriority.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonDescPriority);
        this.jSeparator1.setOrientation(1);
        this.jToolBar1.add(this.jSeparator1);
        this.buttonDelete.setAction((javax.swing.Action)this.cmDeleteTask);
        this.buttonDelete.setHorizontalTextPosition(0);
        this.buttonDelete.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.buttonDelete);
        this.jPanel1.add((Component)this.jToolBar1, "West");
        this.add((Component)this.jPanel1, "North");
        this.jScrollPane1.setViewportView((Component)this.tableTodos);
        this.add((Component)this.jScrollPane1, "Center");
        this.queryTableStatusBar1.setShowFieldType(false);
        this.queryTableStatusBar1.setShowOpenTime(false);
        this.queryTableStatusBar1.setTable((QueryTable)this.tableTodos);
        this.add((Component)this.queryTableStatusBar1, "South");
    }

    private void cmDecPriorityActionPerformed(ActionEvent evt) {
        if (this.tableTodos.getSelectedRow() != -1) {
            try {
                this.tableTodos.getQuery().getRecord(this.tableTodos.getSelectedRow());
                Todo todo = new Todo(this.tableTodos.getQuery().fieldByName("TD_ID").getString());
                todo.fieldByName("TD_PRIORITY").setValue(new Variant(this.tableTodos.getQuery().fieldByName("TD_PRIORITY").getLong() + 1L));
                todo.applyUpdate();
                this.refreshQuery();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmIncPriorityActionPerformed(ActionEvent evt) {
        if (this.tableTodos.getSelectedRow() != -1) {
            try {
                this.tableTodos.getQuery().getRecord(this.tableTodos.getSelectedRow());
                if (this.tableTodos.getQuery().fieldByName("TD_PRIORITY").getLong() > 1L) {
                    Todo todo = new Todo(this.tableTodos.getQuery().fieldByName("TD_ID").getString());
                    todo.fieldByName("TD_PRIORITY").setValue(new Variant(this.tableTodos.getQuery().fieldByName("TD_PRIORITY").getLong() - 1L));
                    todo.applyUpdate();
                    this.refreshQuery();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmSwitchEnableTaskActionPerformed(ActionEvent evt) {
        if (this.tableTodos.getSelectedRow() != -1) {
            try {
                this.tableTodos.getQuery().getRecord(this.tableTodos.getSelectedRow());
                Todo todo = new Todo(this.tableTodos.getQuery().fieldByName("TD_ID").getString());
                if ("T".equals(this.tableTodos.getQuery().fieldByName("TD_ENABLE").getString())) {
                    todo.fieldByName("TD_ENABLE").setValue(new Variant("F"));
                } else {
                    todo.fieldByName("TD_ENABLE").setValue(new Variant("T"));
                }
                todo.applyUpdate();
                this.refreshQuery();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refreshQuery();
    }

    private void cmDeleteTaskActionPerformed(ActionEvent evt) {
        if (this.tableTodos.getQuery().isActive() && this.tableTodos.getSelectedRow() >= 0) {
            try {
                this.tableTodos.getQuery().getRecord(this.tableTodos.getSelectedRow());
                if (MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("TodoPanelView-del-task-q"), this.tableTodos.getQuery().fieldByName("td_title").getString()), (int[])ModalResult.YESNO, (int)3) == 5) {
                    Todo todo = new Todo();
                    todo.getPrimaryKeyField().setValue(new Variant(this.tableTodos.getQuery().fieldByName("TD_ID").getString()));
                    todo.applyDelete();
                    this.refreshQuery();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmEditTaskActionPerformed(ActionEvent evt) {
        try {
            if (this.tableTodos.getQuery().isActive() && this.tableTodos.getSelectedRow() >= 0) {
                this.tableTodos.getQuery().getRecord(this.tableTodos.getSelectedRow());
                if (TodoEditDialog.showDialog(this.tableTodos.getQuery().fieldByName("td_id").getString(), this.td_sch_id) == 1) {
                    this.refreshQuery();
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmNewTaskActionPerformed(ActionEvent evt) {
        try {
            if (this.tableTodos.getQuery().isActive() && TodoEditDialog.showDialog(null, this.td_sch_id) == 1) {
                this.refreshQuery();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmExportTodoActionPerformed(ActionEvent evt) {
        try {
            if (this.tableTodos.getQuery().isActive() && this.tableTodos.getSelectedRow() >= 0) {
                this.tableTodos.getQuery().getRecord(this.tableTodos.getSelectedRow());
                Todo todo = new Todo(this.tableTodos.getQuery().fieldByName("td_id").getString());
                File file = FileUtil.selectFileToSave((Component)this, (String)this.stringManager.getString("saving-task"), (String)(Resolvers.expand((String)"$(orbada.home)") + "/todos"), (File)new File(todo.fieldByName("TD_ID").getString() + ".xml.todo"), (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("task-files"), new String[]{".xml.todo"})});
                if (file != null) {
                    todo.storeToXML(new FileOutputStream(file), "TODO");
                    todo.fieldByName("TD_EXPORTED").setString("T");
                    todo.applyUpdate();
                    this.refreshQuery();
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmImportTodoActionPerformed(ActionEvent evt) {
        if (ImportTodoDialog.showDialog()) {
            this.refreshQuery();
        }
    }
}

