/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class TinySeparatorUI
extends BasicSeparatorUI {
    protected static final Dimension vertDimension = new Dimension(0, 2);
    protected static final Dimension horzDimension = new Dimension(2, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return new TinySeparatorUI();
    }

    protected void installDefaults(JSeparator jSeparator) {
        LookAndFeel.installColors(jSeparator, "Separator.background", "Separator.foreground");
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.drawXpSeparator(graphics, jComponent);
    }

    protected void drawXpSeparator(Graphics graphics, JComponent jComponent) {
        Dimension dimension = jComponent.getSize();
        graphics.setColor(jComponent.getBackground());
        if (((JSeparator)jComponent).getOrientation() == 1) {
            graphics.drawLine(0, 0, 0, dimension.height);
        } else {
            graphics.drawLine(0, 0, dimension.width, 0);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (((JSeparator)jComponent).getOrientation() == 1) {
            return horzDimension;
        }
        return vertDimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }
}

