/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.borders.TinyToolButtonBorder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalToolBarUI;

public class TinyToolBarUI
extends MetalToolBarUI {
    private static List components = new ArrayList();
    public static final String IS_TOOL_BAR_BUTTON_KEY = "isToolbarButton";
    public static final int FLOATABLE_GRIP_SIZE = 8;
    private static Border toolButtonBorder = new TinyToolButtonBorder();

    public static ComponentUI createUI(JComponent jComponent) {
        return new TinyToolBarUI();
    }

    public static boolean doesMenuBarBorderToolBar(JMenuBar jMenuBar) {
        JToolBar jToolBar = (JToolBar)TinyToolBarUI.findRegisteredComponentOfType(jMenuBar, JToolBar.class);
        if (jToolBar != null && jToolBar.getOrientation() == 0) {
            JRootPane jRootPane = SwingUtilities.getRootPane(jMenuBar);
            Point point = new Point(0, 0);
            point = SwingUtilities.convertPoint(jMenuBar, point, jRootPane);
            int n = point.x;
            int n2 = point.y;
            point.y = 0;
            point.x = 0;
            point = SwingUtilities.convertPoint(jToolBar, point, jRootPane);
            return point.x == n && n2 + jMenuBar.getHeight() == point.y && jMenuBar.getWidth() == jToolBar.getWidth();
        }
        return false;
    }

    static synchronized Object findRegisteredComponentOfType(JComponent jComponent, Class clazz) {
        JRootPane jRootPane = SwingUtilities.getRootPane(jComponent);
        if (jRootPane != null) {
            for (int i = components.size() - 1; i >= 0; --i) {
                Object t = ((WeakReference)components.get(i)).get();
                if (t == null) {
                    components.remove(i);
                    continue;
                }
                if (!clazz.isInstance(t) || SwingUtilities.getRootPane((Component)t) != jRootPane) continue;
                return t;
            }
        }
        return null;
    }

    static synchronized void register(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("JComponent must be non-null");
        }
        components.add(new WeakReference<JComponent>(jComponent));
    }

    static synchronized void unregister(JComponent jComponent) {
        for (int i = components.size() - 1; i >= 0; --i) {
            WeakReference weakReference = (WeakReference)components.get(i);
            Object t = ((WeakReference)components.get(i)).get();
            if (t != jComponent && t != null) continue;
            components.remove(i);
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        TinyToolBarUI.register(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.putClientProperty("JToolBar.isRollover", null);
        TinyToolBarUI.unregister(jComponent);
    }

    protected RootPaneContainer createFloatingWindow(JToolBar jToolBar) {
        Window window = SwingUtilities.getWindowAncestor(jToolBar);
        JDialog jDialog = window instanceof Frame ? new JDialog((Frame)window, jToolBar.getName(), false) : (window instanceof Dialog ? new JDialog((Dialog)window, jToolBar.getName(), false) : new JDialog((Frame)null, jToolBar.getName(), false));
        jDialog.setTitle(jToolBar.getName());
        jDialog.setResizable(false);
        WindowListener windowListener = this.createFrameListener();
        jDialog.addWindowListener(windowListener);
        return jDialog;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (jComponent.getBackground() instanceof ColorUIResource) {
            graphics.setColor(Theme.toolBarColor.getColor());
        } else {
            graphics.setColor(jComponent.getBackground());
        }
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    protected void setBorderToRollover(Component component) {
        this.setBorderToNormal(component);
    }

    protected void setBorderToNormal(Component component) {
        if (!(component instanceof AbstractButton)) {
            return;
        }
        if (component instanceof JCheckBox) {
            return;
        }
        if (component instanceof JRadioButton) {
            return;
        }
        AbstractButton abstractButton = (AbstractButton)component;
        abstractButton.setRolloverEnabled(true);
        abstractButton.putClientProperty(IS_TOOL_BAR_BUTTON_KEY, Boolean.TRUE);
        if (!(abstractButton.getBorder() instanceof UIResource) && !(abstractButton.getBorder() instanceof TinyToolButtonBorder)) {
            return;
        }
        abstractButton.setBorder(toolButtonBorder);
    }
}

