/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.util;

import de.muntjak.tinylookandfeel.util.SBReference;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.plaf.ColorUIResource;

public class HSBReference
extends SBReference {
    protected int hue;
    protected boolean preserveGrey;

    public HSBReference(int n, int n2, int n3, int n4) {
        this.hue = n;
        this.sat = n2;
        this.bri = n3;
        this.ref = n4;
        this.preserveGrey = true;
    }

    public HSBReference(HSBReference hSBReference) {
        super(false);
        this.color = new ColorUIResource(hSBReference.color);
        this.hue = hSBReference.hue;
        this.sat = hSBReference.sat;
        this.bri = hSBReference.bri;
        this.ref = hSBReference.ref;
        this.preserveGrey = hSBReference.preserveGrey;
    }

    public void update(HSBReference hSBReference) {
        this.color = new ColorUIResource(hSBReference.color);
        this.hue = hSBReference.hue;
        this.sat = hSBReference.sat;
        this.bri = hSBReference.bri;
        this.ref = hSBReference.ref;
        this.preserveGrey = hSBReference.preserveGrey;
    }

    public void update(HSBReference hSBReference, Vector vector) {
        this.color = new ColorUIResource(hSBReference.color);
        this.hue = hSBReference.hue;
        this.sat = hSBReference.sat;
        this.bri = hSBReference.bri;
        this.ref = hSBReference.ref;
        this.preserveGrey = hSBReference.preserveGrey;
    }

    public int getHue() {
        return this.hue;
    }

    public void setHue(int n) {
        this.hue = n;
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        try {
            this.hue = dataInputStream.readInt();
            this.sat = dataInputStream.readInt();
            this.bri = dataInputStream.readInt();
            this.ref = dataInputStream.readInt();
            this.preserveGrey = dataInputStream.readBoolean();
        }
        catch (Exception exception) {
            throw new IOException("HSBReference.load() : " + exception.getMessage());
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.hue);
        dataOutputStream.writeInt(this.sat);
        dataOutputStream.writeInt(this.bri);
        dataOutputStream.writeInt(this.ref);
        dataOutputStream.writeBoolean(this.preserveGrey);
    }

    public boolean isPreserveGrey() {
        return this.preserveGrey;
    }

    public void setPreserveGrey(boolean bl) {
        this.preserveGrey = bl;
    }

    public String toString() {
        return "HSBReference[bri=" + this.bri + ",sat=" + this.sat + ",hue=" + this.hue + ",ref=" + this.ref + ",c=(" + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue() + ")]";
    }
}

