/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.MalformedInputException;
import java.sql.SQLException;
import java.util.Vector;
import oracle.i18n.text.OraCharset;
import oracle.i18n.text.OraCharsetDecoder;
import oracle.i18n.text.OraCharsetEncoder;
import oracle.i18n.text.converter.GDKMessage;

public class OraCharsetISO2022JP
extends OraCharset {
    static final byte REPLACEMENT_CHAR_IN_BYTE = 63;
    static final byte[] REPLACEMENT_CHAR_IN_BYTES = new byte[]{63};
    static final int ASCII_JISROMAN = 0;
    static final int JISX0208 = 1;
    static final int JISX0212 = 2;
    static final int HALF_WIDTH_KATAKANA = 3;
    static final int BUCKETSIZE = 200;

    OraCharsetISO2022JP(String string, int n) {
        super(string, n);
    }

    public CharsetDecoder newDecoder() {
        return new OraCharsetDecoder(this, 0.5f, 1.0f);
    }

    public CharsetEncoder newEncoder() {
        return new OraCharsetEncoder(this, 10.0f, 10.0f, REPLACEMENT_CHAR_IN_BYTES);
    }

    public String toString(byte[] byArray, int n, int n2) throws SQLException {
        try {
            return this.ISO2022JPToJavaChars(byArray, n, n2, CharacterConverterBehavior.REPORT_ERROR);
        }
        catch (Exception exception) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
    }

    public String toStringWithReplacement(byte[] byArray, int n, int n2) {
        try {
            return this.ISO2022JPToJavaChars(byArray, n, n2, CharacterConverterBehavior.REPLACEMENT);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private int getNextEscpSeq(byte[] byArray, int n) {
        while (n < byArray.length) {
            if (byArray[n] == 27) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int convertToEUCJP(byte[] byArray, Vector vector, int n, int n2, int n3, CharacterConverterBehavior characterConverterBehavior) throws MalformedInputException {
        int n4 = 0;
        int n5 = 0;
        byte[] byArray2 = null;
        if (n2 < n) {
            throw new MalformedInputException(n);
        }
        switch (n3) {
            case 0: {
                byArray2 = new byte[n2 - n + 1];
                vector.add(byArray2);
                n5 = n2 - n + 1;
                n4 = 0;
                while (n <= n2) {
                    if ((byArray[n] < 32 || byArray[n] > 126) && byArray[n] != 13 && byArray[n] != 10) {
                        ((byte[])vector.lastElement())[n4] = 63;
                        characterConverterBehavior.onFailConversion(n);
                    } else {
                        ((byte[])vector.lastElement())[n4] = byArray[n];
                    }
                    ++n;
                    ++n4;
                }
                break;
            }
            case 1: {
                if ((n2 - n) % 2 == 0) {
                    --n2;
                    characterConverterBehavior.onFailConversion(n);
                }
                byArray2 = new byte[n2 - n + 1];
                vector.add(byArray2);
                n5 = n2 - n + 1;
                n4 = 0;
                while (n <= n2) {
                    if (byArray[n] < 33 || byArray[n] > 126) {
                        ((byte[])vector.lastElement())[n4] = -65;
                        characterConverterBehavior.onFailConversion(n);
                    } else {
                        ((byte[])vector.lastElement())[n4] = (byte)(byArray[n] | 0x80);
                    }
                    ++n;
                    ++n4;
                }
                break;
            }
            case 2: {
                if ((n2 - n) % 2 == 0) {
                    --n2;
                }
                byArray2 = new byte[(int)((double)(n2 - n + 1) * 1.5)];
                vector.add(byArray2);
                n5 = (int)((double)(n2 - n + 1) * 1.5);
                n4 = 0;
                while (n <= n2) {
                    if (n4 % 3 == 0) {
                        ((byte[])vector.lastElement())[n4++] = -113;
                    }
                    if (byArray[n] < 33 || byArray[n] > 126) {
                        ((byte[])vector.lastElement())[n4] = -65;
                        characterConverterBehavior.onFailConversion(n);
                    } else {
                        ((byte[])vector.lastElement())[n4] = (byte)(byArray[n] | 0x80);
                    }
                    ++n;
                    ++n4;
                }
                break;
            }
            case 3: {
                byArray2 = new byte[(n2 - n + 1) * 2];
                vector.add(byArray2);
                n5 = (n2 - n + 1) * 2;
                n4 = 0;
                while (n <= n2) {
                    if (n4 % 2 == 0) {
                        ((byte[])vector.lastElement())[n4++] = -114;
                    }
                    if (byArray[n] < 33 || byArray[n] > 126) {
                        ((byte[])vector.lastElement())[n4] = -65;
                        characterConverterBehavior.onFailConversion(n);
                    } else {
                        ((byte[])vector.lastElement())[n4] = (byte)(byArray[n] | 0x80);
                    }
                    ++n;
                    ++n4;
                }
                break;
            }
        }
        return n5;
    }

    private int checkEscpSeq(byte[] byArray, int n) throws MalformedInputException {
        if (n + 2 >= byArray.length) {
            return -1;
        }
        if (byArray[n + 1] == 40) {
            if (byArray[n + 2] == 66 || byArray[n + 2] == 74) {
                return 0;
            }
            if (byArray[n + 2] == 73) {
                return 3;
            }
        } else if (byArray[n + 1] == 36) {
            if (byArray[n + 2] == 64 || byArray[n + 2] == 66) {
                return 1;
            }
            if (byArray[n + 2] == 40 && byArray[n + 3] == 68) {
                return 2;
            }
        }
        return -1;
    }

    private String ISO2022JPToJavaChars(byte[] byArray, int n, int n2, CharacterConverterBehavior characterConverterBehavior) throws MalformedInputException {
        int n3 = n;
        int n4 = n;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl2 = false;
        Vector vector = new Vector(0);
        n4 = this.getNextEscpSeq(byArray, n3);
        if (n4 == -1) {
            n5 += this.convertToEUCJP(byArray, vector, 0, byArray.length - 1, 0, characterConverterBehavior);
            bl = true;
        } else if (n4 != 0) {
            n5 += this.convertToEUCJP(byArray, vector, 0, n4 - 1, 0, characterConverterBehavior);
        }
        while (!bl) {
            int n9;
            n3 = n4;
            if ((n4 = this.getNextEscpSeq(byArray, n4 + 1)) == -1) {
                n4 = byArray.length;
                bl = true;
            }
            if ((n9 = this.checkEscpSeq(byArray, n3)) == 0 || n9 == 1 || n9 == 3) {
                if (n3 + 3 == n4) continue;
                n5 += this.convertToEUCJP(byArray, vector, n3 + 3, n4 - 1, n9, characterConverterBehavior);
                continue;
            }
            if (n9 == 2) {
                if (n3 + 4 == n4) continue;
                n5 += this.convertToEUCJP(byArray, vector, n3 + 4, n4 - 1, n9, characterConverterBehavior);
                continue;
            }
            characterConverterBehavior.onFailConversion(n3);
        }
        byte[] byArray2 = new byte[n5];
        for (n6 = 0; n6 < vector.size(); ++n6) {
            n7 = 0;
            while (n7 < ((byte[])vector.elementAt(n6)).length) {
                byArray2[n8] = ((byte[])vector.elementAt(n6))[n7];
                ++n7;
                ++n8;
            }
        }
        try {
            return new String(byArray2, "EUCJP");
        }
        catch (Exception exception) {
            characterConverterBehavior.onFailConversion(0);
            return new String("");
        }
    }

    public byte[] convert(String string) throws SQLException {
        try {
            return this.JavaCharsToISO2022JP(string, CharacterConverterBehavior.REPORT_ERROR);
        }
        catch (Exception exception) {
            throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
        }
    }

    public byte[] convertWithReplacement(String string) {
        try {
            return this.JavaCharsToISO2022JP(string, CharacterConverterBehavior.REPORT_ERROR);
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    private static int insertToBucket(int n, Vector vector, byte[] byArray) {
        if (n + byArray.length - 1 >= 200) {
            int n2 = 0;
            while (n2 < byArray.length) {
                if (n >= 200) {
                    byte[] byArray2 = new byte[200];
                    vector.add(byArray2);
                    n = 0;
                }
                ((byte[])vector.lastElement())[n] = byArray[n2];
                ++n2;
                ++n;
            }
        } else {
            int n3 = 0;
            while (n3 < byArray.length) {
                ((byte[])vector.lastElement())[n] = byArray[n3];
                ++n3;
                ++n;
            }
        }
        return n;
    }

    private static int insertEscSeq(int n, Vector vector, int n2) {
        byte[] byArray = null;
        if (n2 == 0) {
            byArray = new byte[]{27, 40, 66};
        } else if (n2 == 1) {
            byArray = new byte[]{27, 36, 66};
        } else if (n2 == 2) {
            byArray = new byte[]{27, 36, 40, 68};
        } else if (n2 == 3) {
            byArray = new byte[]{27, 40, 73};
        }
        return OraCharsetISO2022JP.insertToBucket(n, vector, byArray);
    }

    private byte[] JavaCharsToISO2022JP(String string, CharacterConverterBehavior characterConverterBehavior) throws MalformedInputException {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Vector<byte[]> vector = new Vector<byte[]>(0);
        byte[] byArray = null;
        byte[] byArray2 = new byte[200];
        vector.add(byArray2);
        try {
            byArray = string.getBytes("X-ORACLE-JA16EUC");
        }
        catch (Exception exception) {
            characterConverterBehavior.onFailConversion(n3);
            return new byte[0];
        }
        n3 = 0;
        while (n3 < byArray.length) {
            if (byArray[n3] >= 32 && byArray[n3] <= 126 || byArray[n3] == 10 || byArray[n3] == 13) {
                if (n != 0) {
                    if (n3 != 0) {
                        n2 = OraCharsetISO2022JP.insertEscSeq(n2, vector, 0);
                        n4 += 3;
                    }
                    n = 0;
                }
                n2 = OraCharsetISO2022JP.insertToBucket(n2, vector, new byte[]{byArray[n3]});
                ++n3;
                ++n4;
                continue;
            }
            if (byArray[n3] >= -95 && byArray[n3] <= -2) {
                if (n != 1) {
                    n2 = OraCharsetISO2022JP.insertEscSeq(n2, vector, 1);
                    n = 1;
                    n4 += 3;
                }
                n2 = OraCharsetISO2022JP.insertToBucket(n2, vector, new byte[]{(byte)(byArray[n3] & 0x7F), (byte)(byArray[n3 + 1] & 0x7F)});
                n3 += 2;
                n4 += 2;
                continue;
            }
            if (byArray[n3] == -114) {
                if (n != 3) {
                    n2 = OraCharsetISO2022JP.insertEscSeq(n2, vector, 3);
                    n = 3;
                    n4 += 3;
                }
                n2 = OraCharsetISO2022JP.insertToBucket(n2, vector, new byte[]{(byte)(byArray[n3 + 1] & 0x7F)});
                n3 += 2;
                ++n4;
                continue;
            }
            if (byArray[n3] == -113) {
                if (n != 2) {
                    n2 = OraCharsetISO2022JP.insertEscSeq(n2, vector, 2);
                    n = 2;
                    n4 += 4;
                }
                n2 = OraCharsetISO2022JP.insertToBucket(n2, vector, new byte[]{(byte)(byArray[n3 + 1] & 0x7F), (byte)(byArray[n3 + 2] & 0x7F)});
                n3 += 3;
                n4 += 2;
                continue;
            }
            characterConverterBehavior.onFailConversion(n3);
            ++n3;
        }
        if (n != 0) {
            n2 = OraCharsetISO2022JP.insertEscSeq(n2, vector, 0);
            n4 += 3;
        }
        byte[] byArray3 = new byte[n4];
        for (n5 = 0; n5 < vector.size(); ++n5) {
            int n8 = (n4 - n7) / 200 > 0 ? 200 : n4 % 200;
            n6 = 0;
            while (n6 < n8) {
                byArray3[n7] = ((byte[])vector.elementAt(n5))[n6];
                ++n6;
                ++n7;
            }
        }
        return byArray3;
    }

    private static abstract class CharacterConverterBehavior {
        public static final CharacterConverterBehavior REPORT_ERROR = new CharacterConverterBehavior(){

            public void onFailConversion(int n) throws MalformedInputException {
                throw new MalformedInputException(n);
            }
        };
        public static final CharacterConverterBehavior REPLACEMENT = new CharacterConverterBehavior(){

            public void onFailConversion(int n) throws MalformedInputException {
            }
        };

        public abstract void onFailConversion(int var1) throws MalformedInputException;
    }
}

