/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql;

import java.util.ArrayList;
import java.util.List;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.Template;
import pl.mpak.orbada.mysql.cm.FindObjectFromEditorAction;
import pl.mpak.orbada.mysql.services.ExplainPlanProvider;
import pl.mpak.orbada.mysql.services.MySQLAutotraceProvider;
import pl.mpak.orbada.mysql.services.MySQLDatabaseProvider;
import pl.mpak.orbada.mysql.services.MySQLDbInfoProvider;
import pl.mpak.orbada.mysql.services.MySQLFocusProvider;
import pl.mpak.orbada.mysql.services.MySQLFunctionsView;
import pl.mpak.orbada.mysql.services.MySQLHelpView;
import pl.mpak.orbada.mysql.services.MySQLPerspectiveProvider;
import pl.mpak.orbada.mysql.services.MySQLProceduresView;
import pl.mpak.orbada.mysql.services.MySQLSearchObjectView;
import pl.mpak.orbada.mysql.services.MySQLSessionsView;
import pl.mpak.orbada.mysql.services.MySQLTablesView;
import pl.mpak.orbada.mysql.services.MySQLTemplatesSettingsProvider;
import pl.mpak.orbada.mysql.services.MySQLTriggersView;
import pl.mpak.orbada.mysql.services.MySQLViewsView;
import pl.mpak.orbada.mysql.services.UniversalColumnProvider;
import pl.mpak.orbada.mysql.services.actions.FunctionActionsService;
import pl.mpak.orbada.mysql.services.actions.ObjectSearchActionsService;
import pl.mpak.orbada.mysql.services.actions.ProcedureActionsService;
import pl.mpak.orbada.mysql.services.actions.SessionViewActionsService;
import pl.mpak.orbada.mysql.services.actions.TableActionsService;
import pl.mpak.orbada.mysql.services.actions.TableColumnActionsService;
import pl.mpak.orbada.mysql.services.actions.TableConstraintActionsService;
import pl.mpak.orbada.mysql.services.actions.TableIndexActionsService;
import pl.mpak.orbada.mysql.services.actions.TableTriggerActionsService;
import pl.mpak.orbada.mysql.services.actions.TableUtilsActionsService;
import pl.mpak.orbada.mysql.services.actions.TriggerActionsService;
import pl.mpak.orbada.mysql.services.actions.ViewActionsService;
import pl.mpak.orbada.mysql.services.actions.ViewColumnActionsService;
import pl.mpak.orbada.mysql.services.actions.ViewUtilsActionsService;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.OrbadaPlugin;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.plugins.spi.IPlugin;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.VersionID;
import pl.mpak.util.timer.TimerManager;
import pl.mpak.util.timer.TimerQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbadaMySQLPlugin
extends OrbadaPlugin {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    public static final String driverType = "MySQL";
    public static final String adminGroup = stringManager.getString("OrbadaMySQLPlugin-admin-group");
    public static final String specjalMySQLActions = "mysql-actions";
    private static TimerQueue refreshQueue;
    public static final ArrayList<Class<? extends IPluginProvider>> classList;
    public static FindObjectFromEditorAction findObjectAction;

    public static TimerQueue getRefreshQueue() {
        if (refreshQueue == null) {
            refreshQueue = TimerManager.getTimer((String)"orbada-mysql-refresh");
        }
        return refreshQueue;
    }

    public String getInternalName() {
        return "OrbadaMySQLPlugin";
    }

    public String getDescriptiveName() {
        return String.format(stringManager.getString("OrbadaMySQLPlugin-descriptive-name"), this.getVersion());
    }

    public String getDescription() {
        return "";
    }

    public String getCategory() {
        return "IDE,Database,MySQL";
    }

    public String getAuthor() {
        return "Andrzej Ka\u0142u\u017ca";
    }

    public String getCopyrights() {
        return "";
    }

    public String getWebSite() {
        return null;
    }

    public String getUpdateSite() {
        return null;
    }

    public String getVersion() {
        return new VersionID(1, 1, 0, 37).toString();
    }

    public String getLicence() {
        return null;
    }

    public String getUniqueID() {
        return "orbada-mysql-plugin";
    }

    public void load() {
    }

    public void unload() {
    }

    public void initialize() {
        this.application.registerDriverType(driverType);
        findObjectAction = new FindObjectFromEditorAction();
        classList.add(MySQLDatabaseProvider.class);
        classList.add(MySQLDbInfoProvider.class);
        classList.add(MySQLHelpView.class);
        classList.add(MySQLTablesView.class);
        classList.add(MySQLViewsView.class);
        classList.add(MySQLProceduresView.class);
        classList.add(MySQLFunctionsView.class);
        classList.add(TableActionsService.class);
        classList.add(TableColumnActionsService.class);
        classList.add(TableIndexActionsService.class);
        classList.add(TableConstraintActionsService.class);
        classList.add(TableTriggerActionsService.class);
        classList.add(ViewActionsService.class);
        classList.add(ViewColumnActionsService.class);
        classList.add(ProcedureActionsService.class);
        classList.add(FunctionActionsService.class);
        classList.add(UniversalColumnProvider.class);
        classList.add(MySQLPerspectiveProvider.class);
        classList.add(MySQLTriggersView.class);
        classList.add(TriggerActionsService.class);
        classList.add(MySQLTemplatesSettingsProvider.class);
        classList.add(MySQLAutotraceProvider.class);
        classList.add(MySQLSessionsView.class);
        classList.add(MySQLSearchObjectView.class);
        classList.add(MySQLFocusProvider.class);
        classList.add(SessionViewActionsService.class);
        classList.add(TableUtilsActionsService.class);
        classList.add(ViewUtilsActionsService.class);
        classList.add(ObjectSearchActionsService.class);
        this.initTemplates();
    }

    public boolean requires(List<IPlugin> loadedPlugins) {
        this.addDepend("orbada-universal-plugin");
        for (IPlugin plugin : loadedPlugins) {
            if (!"orbada-universal-plugin".equals(plugin.getUniqueID())) continue;
            classList.add(ExplainPlanProvider.class);
        }
        return true;
    }

    public Class<IPluginProvider>[] getProviderArray() {
        return classList.toArray(new Class[classList.size()]);
    }

    public void processMessage(PluginMessage message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTemplates() {
        if (InternalDatabase.get() == null) {
            return;
        }
        Query query = InternalDatabase.get().createQuery();
        try {
            ISettings settings;
            query.open("select count( 0 ) cnt from templates where tpl_name like 'mysql-%'");
            if (query.fieldByName("cnt").getInteger() == 0) {
                Template template = new Template(this.application.getOrbadaDatabase());
                template.setName("mysql-function");
                template.setDescription("MySQL Function Template");
                template.setUsrId("");
                template.setBody("CREATE FUNCTION $(&name)($(&parameters)) RETURNS $(&return)\n  $(pr&operties)\nBEGIN\n  -- ############################################################################\n  -- # ORBADA   : To change this template, choose Tools | Templates\n  -- # Author   : $(orbada.user.name)\n  -- # Created  : $(orbada.current.date) $(orbada.current.time)\n  -- ############################################################################\n  --\n  /* TODO function implementation */\n$(&body)\nEND");
                template.applyInsert();
                template = new Template(this.application.getOrbadaDatabase());
                template.setName("mysql-procedure");
                template.setDescription("MySQL Procedure Template");
                template.setUsrId("");
                template.setBody("CREATE PROCEDURE $(&name)($(&parameters))\n  $(pr&operties)\nBEGIN\n  -- ############################################################################\n  -- # ORBADA   : To change this template, choose Tools | Templates\n  -- # Author   : $(orbada.user.name)\n  -- # Created  : $(orbada.current.date) $(orbada.current.time)\n  -- ############################################################################\n  --\n  /* TODO procedure implementation */\n$(&body)\nEND");
                template.applyInsert();
                template = new Template(this.application.getOrbadaDatabase());
                template.setName("mysql-trigger");
                template.setDescription("MySQL Trigger Template");
                template.setUsrId("");
                template.setBody("CREATE TRIGGER $(&name)\n$(&type)\nBEGIN\n  -- ############################################################################\n  -- # ORBADA   : To change this template, choose Tools | Templates\n  -- # Author   : $(orbada.user.name)\n  -- # Created  : $(orbada.current.date) $(orbada.current.time)\n  -- ############################################################################\n  --\n  /* TODO trigger implementation */\n$(&body)\nEND");
                template.applyInsert();
            }
            if ((settings = Application.get().getSettings(MySQLTemplatesSettingsProvider.settingsName)).getValue(MySQLTemplatesSettingsProvider.setFunction).isNull()) {
                settings.setValue(MySQLTemplatesSettingsProvider.setFunction, "mysql-function");
            }
            if (settings.getValue(MySQLTemplatesSettingsProvider.setProcedure).isNull()) {
                settings.setValue(MySQLTemplatesSettingsProvider.setProcedure, "mysql-procedure");
            }
            if (settings.getValue(MySQLTemplatesSettingsProvider.setTrigger).isNull()) {
                settings.setValue(MySQLTemplatesSettingsProvider.setTrigger, "mysql-trigger");
            }
            settings.store();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    static {
        classList = new ArrayList();
    }
}

