/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CopyTableColumnsAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public CopyTableColumnsAction() {
        this.setText(this.stringManager.getString("CopyTableColumnsAction-text"));
        this.setTooltip(this.stringManager.getString("CopyTableColumnsAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/copy.gif"));
        this.setActionCommandKey("CopyTableColumnsAction");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CopyTableColumnsAction.this.getComponent() instanceof ViewTable) {
                    ViewTable vt = (ViewTable)CopyTableColumnsAction.this.getComponent();
                    try {
                        StringBuffer sb = new StringBuffer();
                        int l = 0;
                        vt.getQuery().first();
                        while (!vt.getQuery().eof()) {
                            if (sb.length() > 0) {
                                sb.append(", ");
                                l += 2;
                            }
                            if (l > 100) {
                                l = 0;
                                sb.append('\n');
                            }
                            String column = SQLUtil.createSqlName((String)vt.getQuery().fieldByName("column_name").getString());
                            sb.append(column);
                            l += column.length();
                            vt.getQuery().next();
                        }
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        clipboard.setContents(new StringSelection(sb.toString()), null);
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)CopyTableColumnsAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }

    public boolean isToolButton() {
        return true;
    }
}

