/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.gui.functions.FunctionsPanelView;
import pl.mpak.orbada.mysql.gui.wizards.CreateFunctionWizard;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CreateFunctionAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public CreateFunctionAction() {
        this.setText(this.stringManager.getString("CreateFunctionAction-text"));
        this.setTooltip(this.stringManager.getString("CreateFunctionAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/function.gif"));
        this.setActionCommandKey("CreateFunctionAction");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CreateFunctionAction.this.getComponent() instanceof ViewTable) {
                    ViewTable vt = (ViewTable)CreateFunctionAction.this.getComponent();
                    FunctionsPanelView panel = (FunctionsPanelView)((Object)SwingUtil.getOwnerComponent(FunctionsPanelView.class, (Component)CreateFunctionAction.this.getComponent()));
                    if (panel != null) {
                        try {
                            String databaseName = panel.getCurrentSchemaName();
                            SqlCodeWizardDialog.WizardResult result = SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateFunctionWizard(CreateFunctionAction.this.getDatabase(), databaseName), (boolean)true);
                            if (result != null) {
                                panel.refresh((String)result.getResultMap().get("name"));
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.show((String)CreateFunctionAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                        }
                    }
                }
            }
        };
    }

    public boolean isToolButton() {
        return true;
    }
}

