/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DropProcedureAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public DropProcedureAction() {
        this.setText(this.stringManager.getString("DropProcedureAction-description"));
        this.setTooltip(this.stringManager.getString("DropProcedureAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.setActionCommandKey("DropProcedureAction");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DropProcedureAction.this.getComponent() instanceof ViewTable) {
                    ViewTable vt = (ViewTable)DropProcedureAction.this.getComponent();
                    IRootTabObjectInfo ip = (IRootTabObjectInfo)SwingUtil.getOwnerComponent(IRootTabObjectInfo.class, (Component)DropProcedureAction.this.getComponent());
                    if (vt.getSelectedRow() >= 0) {
                        try {
                            vt.getQuery().getRecord(vt.getSelectedRow());
                            String databaseName = vt.getQuery().fieldByName("routine_schema").getString();
                            String tableName = vt.getQuery().fieldByName("routine_name").getString();
                            if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)DropProcedureAction.this.stringManager.getString("deleting"), (String)DropProcedureAction.this.stringManager.getString("DropProcedureAction-delete-procedure-q"), (int[])ModalResult.YESNO, (int)3) == 5) {
                                DropProcedureAction.this.getDatabase().executeCommand("DROP PROCEDURE " + SQLUtil.createSqlName((String)databaseName, (String)tableName, (Database)DropProcedureAction.this.getDatabase()));
                                ip.refresh(null);
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.show((String)DropProcedureAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                        }
                    }
                }
            }
        };
    }

    public boolean isToolButton() {
        return false;
    }
}

