/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DropTableAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public DropTableAction() {
        this.setText(this.stringManager.getString("DropTableAction-description"));
        this.setTooltip(this.stringManager.getString("DropTableAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.setActionCommandKey("DropTableAction");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DropTableAction.this.getComponent() instanceof ViewTable) {
                    ViewTable vt = (ViewTable)DropTableAction.this.getComponent();
                    IRootTabObjectInfo ip = (IRootTabObjectInfo)SwingUtil.getOwnerComponent(IRootTabObjectInfo.class, (Component)DropTableAction.this.getComponent());
                    if (vt.getSelectedRow() >= 0) {
                        try {
                            vt.getQuery().getRecord(vt.getSelectedRow());
                            String databaseName = vt.getQuery().fieldByName("table_schema").getString();
                            String tableName = vt.getQuery().fieldByName("table_name").getString();
                            if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)DropTableAction.this.stringManager.getString("deleting"), (String)DropTableAction.this.stringManager.getString("DropTableAction-delete-table-q"), (int[])ModalResult.YESNO, (int)3) == 5) {
                                DropTableAction.this.getDatabase().executeCommand("DROP TABLE " + SQLUtil.createSqlName((String)databaseName, (String)tableName, (Database)DropTableAction.this.getDatabase()));
                                ip.refresh(null);
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.show((String)DropTableAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                        }
                    }
                }
            }
        };
    }

    public boolean isToolButton() {
        return false;
    }
}

