/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DropTableColumnAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public DropTableColumnAction() {
        this.setText(this.stringManager.getString("DropTableColumnAction-text"));
        this.setTooltip(this.stringManager.getString("DropTableColumnAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.setActionCommandKey("DropTableColumnAction");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DropTableColumnAction.this.getComponent() instanceof ViewTable) {
                    ViewTable vt = (ViewTable)DropTableColumnAction.this.getComponent();
                    ITabObjectInfo ip = (ITabObjectInfo)SwingUtil.getOwnerComponent(ITabObjectInfo.class, (Component)DropTableColumnAction.this.getComponent());
                    if (vt.getSelectedRow() >= 0) {
                        try {
                            vt.getQuery().getRecord(vt.getSelectedRow());
                            String databaseName = vt.getQuery().fieldByName("table_schema").getString();
                            String tableName = vt.getQuery().fieldByName("table_name").getString();
                            String columnName = vt.getQuery().fieldByName("column_name").getString();
                            if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)DropTableColumnAction.this.stringManager.getString("deleting"), (String)DropTableColumnAction.this.stringManager.getString("DropTableColumnAction-delete-q"), (int[])ModalResult.YESNO, (int)3) == 5) {
                                DropTableColumnAction.this.getDatabase().executeCommand("ALTER TABLE " + SQLUtil.createSqlName((String)databaseName, (String)tableName, (Database)DropTableColumnAction.this.getDatabase()) + " DROP COLUMN " + SQLUtil.createSqlName((String)columnName, (Database)DropTableColumnAction.this.getDatabase()));
                                ip.refresh();
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.show((String)DropTableColumnAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                        }
                    }
                }
            }
        };
    }

    public boolean isToolButton() {
        return false;
    }
}

