/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class DropTableConstraintAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public DropTableConstraintAction() {
        this.setText(this.stringManager.getString("DropTableConstraintAction-text"));
        this.setTooltip(this.stringManager.getString("DropTableConstraintAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.setActionCommandKey("DropTableConstraintAction");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DropTableConstraintAction.this.getComponent() instanceof ViewTable) {
                    ViewTable vt = (ViewTable)DropTableConstraintAction.this.getComponent();
                    ITabObjectInfo ip = (ITabObjectInfo)SwingUtil.getOwnerComponent(ITabObjectInfo.class, (Component)DropTableConstraintAction.this.getComponent());
                    if (vt.getSelectedRow() >= 0) {
                        try {
                            vt.getQuery().getRecord(vt.getSelectedRow());
                            String databaseName = vt.getQuery().fieldByName("table_schema").getString();
                            String tableName = vt.getQuery().fieldByName("table_name").getString();
                            String constrName = vt.getQuery().fieldByName("constraint_name").getString();
                            String constrType = vt.getQuery().fieldByName("constraint_type").getString();
                            if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)DropTableConstraintAction.this.stringManager.getString("deleting"), (String)DropTableConstraintAction.this.stringManager.getString("DropTableConstraintAction-delete-constr-q"), (int[])ModalResult.YESNO, (int)3) == 5) {
                                if (StringUtil.equals((String)"PRIMARY KEY", (String)constrType)) {
                                    DropTableConstraintAction.this.getDatabase().executeCommand("ALTER TABLE " + SQLUtil.createSqlName((String)databaseName, (String)tableName, (Database)DropTableConstraintAction.this.getDatabase()) + " DROP PRIMARY KEY");
                                } else if (StringUtil.equals((String)"FOREIGN KEY", (String)constrType)) {
                                    DropTableConstraintAction.this.getDatabase().executeCommand("ALTER TABLE " + SQLUtil.createSqlName((String)databaseName, (String)tableName, (Database)DropTableConstraintAction.this.getDatabase()) + " DROP FOREIGN KEY " + SQLUtil.createSqlName((String)constrName, (Database)DropTableConstraintAction.this.getDatabase()));
                                } else if (StringUtil.equals((String)"UNIQUE", (String)constrType)) {
                                    DropTableConstraintAction.this.getDatabase().executeCommand("ALTER TABLE " + SQLUtil.createSqlName((String)databaseName, (String)tableName, (Database)DropTableConstraintAction.this.getDatabase()) + " DROP INDEX " + SQLUtil.createSqlName((String)constrName, (Database)DropTableConstraintAction.this.getDatabase()));
                                }
                                ip.refresh();
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.show((String)DropTableConstraintAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                        }
                    }
                }
            }
        };
    }

    public boolean isToolButton() {
        return false;
    }
}

