/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class DropTableIndexAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public DropTableIndexAction() {
        this.setText(this.stringManager.getString("DropTableIndexAction-text"));
        this.setTooltip(this.stringManager.getString("DropTableIndexAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.setActionCommandKey("DropTableIndexAction");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DropTableIndexAction.this.getComponent() instanceof ViewTable) {
                    ViewTable vt = (ViewTable)DropTableIndexAction.this.getComponent();
                    ITabObjectInfo ip = (ITabObjectInfo)SwingUtil.getOwnerComponent(ITabObjectInfo.class, (Component)DropTableIndexAction.this.getComponent());
                    if (vt.getSelectedRow() >= 0) {
                        try {
                            vt.getQuery().getRecord(vt.getSelectedRow());
                            String databaseName = vt.getQuery().fieldByName("table_schema").getString();
                            String tableName = vt.getQuery().fieldByName("table_name").getString();
                            String indexName = vt.getQuery().fieldByName("index_name").getString();
                            if (StringUtil.equals((String)"PRIMARY", (String)indexName)) {
                                if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)DropTableIndexAction.this.stringManager.getString("deleting"), (String)DropTableIndexAction.this.stringManager.getString("DropTableIndexAction-delete-pk-q"), (int[])ModalResult.YESNO, (int)3) == 5) {
                                    DropTableIndexAction.this.getDatabase().executeCommand("ALTER TABLE " + SQLUtil.createSqlName((String)databaseName, (String)tableName, (Database)DropTableIndexAction.this.getDatabase()) + " DROP PRIMARY KEY");
                                    ip.refresh();
                                }
                            } else if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)DropTableIndexAction.this.stringManager.getString("deleting"), (String)DropTableIndexAction.this.stringManager.getString("DropTableIndexAction-delete-index-q"), (int[])ModalResult.YESNO, (int)3) == 5) {
                                DropTableIndexAction.this.getDatabase().executeCommand("ALTER TABLE " + SQLUtil.createSqlName((String)databaseName, (String)tableName, (Database)DropTableIndexAction.this.getDatabase()) + " DROP INDEX " + SQLUtil.createSqlName((String)indexName, (Database)DropTableIndexAction.this.getDatabase()));
                                ip.refresh();
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.show((String)DropTableIndexAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                        }
                    }
                }
            }
        };
    }

    public boolean isToolButton() {
        return false;
    }
}

