/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.text.BadLocationException;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.PerspectiveAccesibilities;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.mysql.gui.freezing.FreezeFactory;
import pl.mpak.orbada.mysql.gui.freezing.FreezeViewService;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.syntax.SyntaxEditor;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class FindObjectFromEditorAction
extends Action {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private Database database;
    private SyntaxEditor syntaxEditor;

    public FindObjectFromEditorAction() {
        this.setText(this.stringManager.getString("FindObjectFromEditorAction-text"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/find_editor.gif"));
        this.setTooltip(this.stringManager.getString("FindObjectFromEditorAction-hint"));
        this.setShortCut(118, 3);
        this.setActionCommandKey("FindObjectFromEditorAction");
        this.addActionListener(this.createActionListener());
    }

    public SyntaxEditor getSyntaxEditor() {
        return this.syntaxEditor;
    }

    public void setSyntaxEditor(SyntaxEditor syntaxEditor) {
        this.syntaxEditor = syntaxEditor;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    private boolean resolveObject(String type, String schema, String object) {
        if (StringUtil.anyOfString((String)type, (String[])new String[]{"TABLE", "VIEW", "PROCEDURE", "FUNCTION", "TRIGGER"}, (boolean)true) != -1) {
            FreezeViewService service = new FreezeFactory().createInstance(type, schema, object);
            PerspectiveAccesibilities accessibilities = Application.get().getMainFrame().getActivePerspective().getPerspectiveAccesibilities();
            if (service != null && accessibilities != null) {
                accessibilities.createView((ViewProvider)service);
            }
            return true;
        }
        return false;
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                block12: {
                    try {
                        String[] words = FindObjectFromEditorAction.this.syntaxEditor.getWordsAt(FindObjectFromEditorAction.this.syntaxEditor.getCaretPosition());
                        String object = null;
                        String schema = null;
                        if (words == null || words.length <= 0) break block12;
                        if (words.length == 1) {
                            object = SQLUtil.normalizeSqlName((String)words[0]);
                        } else {
                            schema = SQLUtil.normalizeSqlName((String)words[0]);
                            object = SQLUtil.normalizeSqlName((String)words[1]);
                        }
                        boolean found = false;
                        Query query = FindObjectFromEditorAction.this.database.createQuery();
                        try {
                            query.setSqlText(Sql.getObjectsType(null));
                            query.paramByName("schema_name").setString(schema);
                            query.paramByName("object_name").setString(object);
                            query.open();
                            if (!query.eof()) {
                                schema = query.fieldByName("object_schema").getString();
                                object = query.fieldByName("object_name").getString();
                                found = FindObjectFromEditorAction.this.resolveObject(query.fieldByName("object_type").getString(), schema, object);
                            }
                            if (!found) {
                                object = schema;
                                schema = null;
                                query.close();
                                query.paramByName("schema_name").setString(schema);
                                query.paramByName("object_name").setString(object);
                                query.open();
                                if (!query.eof()) {
                                    schema = query.fieldByName("object_schema").getString();
                                    object = query.fieldByName("object_name").getString();
                                    found = FindObjectFromEditorAction.this.resolveObject(query.fieldByName("object_type").getString(), schema, object);
                                }
                            }
                        }
                        catch (Exception ex) {
                            ExceptionUtil.processException((Throwable)ex);
                        }
                        finally {
                            query.close();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        };
    }
}

