/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class KillQueryAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public KillQueryAction() {
        this.setActionCommandKey("KillQueryAction");
        this.setSmallIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/stop-query.gif")));
        this.setText(this.stringManager.getString("cmKillQuery-text"));
        this.setTooltip(this.stringManager.getString("cmKillQuery-hint"));
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (KillQueryAction.this.getComponent() instanceof ViewTable) {
                    ViewTable vt = (ViewTable)KillQueryAction.this.getComponent();
                    final IRootTabObjectInfo ip = (IRootTabObjectInfo)SwingUtil.getOwnerComponent(IRootTabObjectInfo.class, (Component)KillQueryAction.this.getComponent());
                    if (vt.getSelectedRow() >= 0) {
                        try {
                            vt.getQuery().getRecord(vt.getSelectedRow());
                            String session = vt.getQuery().fieldByName("id").getString();
                            if (MessageBox.show((Component)KillQueryAction.this.getComponent(), (String)KillQueryAction.this.stringManager.getString("connection"), (String)KillQueryAction.this.stringManager.getString("kill-query-q", (Object)session), (int[])ModalResult.YESNO, (int)3) == 5) {
                                KillQueryAction.this.getDatabase().executeCommand("KILL QUERY " + session);
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        ip.refresh();
                                    }
                                });
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.show((String)KillQueryAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                        }
                    }
                }
            }
        };
    }

    public boolean isToolButton() {
        return true;
    }
}

