/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class KillSessionAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public KillSessionAction() {
        this.setActionCommandKey("KillSessionAction");
        this.setSmallIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/stop16.gif")));
        this.setText(this.stringManager.getString("cmKillSession-text"));
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (KillSessionAction.this.getComponent() instanceof ViewTable) {
                    ViewTable vt = (ViewTable)KillSessionAction.this.getComponent();
                    final IRootTabObjectInfo ip = (IRootTabObjectInfo)SwingUtil.getOwnerComponent(IRootTabObjectInfo.class, (Component)KillSessionAction.this.getComponent());
                    if (vt.getSelectedRow() >= 0) {
                        try {
                            vt.getQuery().getRecord(vt.getSelectedRow());
                            String session = vt.getQuery().fieldByName("id").getString();
                            if (MessageBox.show((Component)KillSessionAction.this.getComponent(), (String)KillSessionAction.this.stringManager.getString("connection"), (String)KillSessionAction.this.stringManager.getString("kill-connection-q", (Object)session), (int[])ModalResult.YESNO, (int)3) == 5) {
                                KillSessionAction.this.getDatabase().executeCommand("KILL CONNECTION " + session);
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        ip.refresh();
                                    }
                                });
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.show((String)KillSessionAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                        }
                    }
                }
            }
        };
    }

    public boolean isToolButton() {
        return true;
    }
}

