/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.gui.freezing.FreezeFactory;
import pl.mpak.orbada.mysql.gui.freezing.FreezeViewService;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ObjectFreezeAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private FreezeFactory freezeFactory;
    private IViewAccesibilities accesibilities;

    public ObjectFreezeAction() {
        this.setText(this.stringManager.getString("FreezeAction-description"));
        this.setTooltip(this.stringManager.getString("FreezeAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.setShortCut(114, 0);
        this.setActionCommandKey("FreezeAction");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTable vt;
                if (ObjectFreezeAction.this.getComponent() instanceof ViewTable && (vt = (ViewTable)ObjectFreezeAction.this.getComponent()).getSelectedRow() >= 0) {
                    try {
                        vt.getQuery().getRecord(vt.getSelectedRow());
                        String databaseName = vt.getQuery().fieldByName("object_schema").getString();
                        String objectName = vt.getQuery().fieldByName("object_name").getString();
                        String objectType = vt.getQuery().fieldByName("object_type").getString();
                        FreezeViewService service = ObjectFreezeAction.this.freezeFactory.createInstance(objectType, databaseName, objectName);
                        if (service != null) {
                            ObjectFreezeAction.this.accesibilities.createView((ViewProvider)service);
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)ObjectFreezeAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }

    public void setComponent(Component component) {
        super.setComponent(component);
        if (component instanceof ViewTable) {
            PerspectivePanel panel = (PerspectivePanel)SwingUtil.getOwnerComponent(PerspectivePanel.class, (Component)component);
            this.accesibilities = panel.getViewAccesibilitiesForChild(this.getComponent());
            this.freezeFactory = new FreezeFactory(this.accesibilities);
            final ViewTable vt = (ViewTable)component;
            vt.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (vt.getSelectedRow() >= 0) {
                        try {
                            vt.getQuery().getRecord(vt.getSelectedRow());
                            ObjectFreezeAction.this.setEnabled(ObjectFreezeAction.this.freezeFactory.canCreate(vt.getQuery().fieldByName("object_type").getString()));
                        }
                        catch (Exception ex) {
                            ExceptionUtil.processException((Throwable)ex);
                        }
                    }
                }
            });
        }
    }

    public boolean isToolButton() {
        return true;
    }
}

