/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.gui.wizards.OrderByTableWizardPanel;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class OrderByTableAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public OrderByTableAction() {
        this.setText(this.stringManager.getString("OrderByTableAction-text"));
        this.setTooltip(this.stringManager.getString("OrderByTableAction-hint"));
        this.setActionCommandKey("OrderByTableAction");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (OrderByTableAction.this.getComponent() instanceof ViewTable) {
                    ViewTable vt = (ViewTable)OrderByTableAction.this.getComponent();
                    IRootTabObjectInfo ip = (IRootTabObjectInfo)SwingUtil.getOwnerComponent(IRootTabObjectInfo.class, (Component)OrderByTableAction.this.getComponent());
                    if (vt.getSelectedRow() >= 0) {
                        try {
                            vt.getQuery().getRecord(vt.getSelectedRow());
                            String databaseName = vt.getQuery().fieldByName("table_schema").getString();
                            String tableName = vt.getQuery().fieldByName("table_name").getString();
                            if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)new OrderByTableWizardPanel(OrderByTableAction.this.getDatabase(), databaseName, tableName), (boolean)true) != null) {
                                ip.refresh();
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.show((String)OrderByTableAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                        }
                    }
                }
            }
        };
    }

    public boolean isToolButton() {
        return false;
    }
}

