/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.gui.wizards.RenameTableWizard;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class RenameTableAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public RenameTableAction() {
        this.setText(this.stringManager.getString("RenameTableAction-text"));
        this.setTooltip(this.stringManager.getString("RenameTableAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/rename.gif"));
        this.setActionCommandKey("RenameTableAction");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (RenameTableAction.this.getComponent() instanceof ViewTable) {
                    ViewTable vt = (ViewTable)RenameTableAction.this.getComponent();
                    IRootTabObjectInfo ip = (IRootTabObjectInfo)SwingUtil.getOwnerComponent(IRootTabObjectInfo.class, (Component)RenameTableAction.this.getComponent());
                    if (vt.getSelectedRow() >= 0) {
                        try {
                            vt.getQuery().getRecord(vt.getSelectedRow());
                            String databaseName = vt.getQuery().fieldByName("table_schema").getString();
                            String tableName = vt.getQuery().fieldByName("table_name").getString();
                            RenameTableWizard wizard = new RenameTableWizard(RenameTableAction.this.getDatabase(), databaseName, tableName);
                            if (SqlCodeWizardDialog.show((SqlCodeWizardPanel)wizard, (boolean)true) != null) {
                                ip.refresh((String)wizard.getResultMap().get("new-table-name"));
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.show((String)RenameTableAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                        }
                    }
                }
            }
        };
    }

    public boolean isToolButton() {
        return false;
    }
}

