/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.gui.freezing.FreezeFactory;
import pl.mpak.orbada.mysql.gui.freezing.FreezeViewService;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TriggerFreezeAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public TriggerFreezeAction() {
        this.setText(this.stringManager.getString("FreezeAction-description"));
        this.setTooltip(this.stringManager.getString("FreezeAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.setShortCut(114, 0);
        this.setActionCommandKey("FreezeAction");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTable vt;
                if (TriggerFreezeAction.this.getComponent() instanceof ViewTable && (vt = (ViewTable)TriggerFreezeAction.this.getComponent()).getSelectedRow() >= 0) {
                    PerspectivePanel panel = (PerspectivePanel)SwingUtil.getOwnerComponent(PerspectivePanel.class, (Component)TriggerFreezeAction.this.getComponent());
                    IViewAccesibilities accesibilities = panel.getViewAccesibilitiesForChild(TriggerFreezeAction.this.getComponent());
                    FreezeFactory freezeFactory = new FreezeFactory(accesibilities);
                    try {
                        vt.getQuery().getRecord(vt.getSelectedRow());
                        String databaseName = vt.getQuery().fieldByName("trigger_schema").getString();
                        String objectName = vt.getQuery().fieldByName("trigger_name").getString();
                        FreezeViewService service = freezeFactory.createInstance("TRIGGER", databaseName, objectName);
                        if (service != null) {
                            accesibilities.createView((ViewProvider)service);
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)TriggerFreezeAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }

    public boolean isToolButton() {
        return true;
    }
}

