/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TruncateTableAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public TruncateTableAction() {
        this.setText(this.stringManager.getString("TruncateTableAction-description"));
        this.setTooltip(this.stringManager.getString("TruncateTableAction-hint"));
        this.setActionCommandKey("TruncateTableAction");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TruncateTableAction.this.getComponent() instanceof ViewTable) {
                    ViewTable vt = (ViewTable)TruncateTableAction.this.getComponent();
                    IRootTabObjectInfo ip = (IRootTabObjectInfo)SwingUtil.getOwnerComponent(IRootTabObjectInfo.class, (Component)TruncateTableAction.this.getComponent());
                    if (vt.getSelectedRow() >= 0) {
                        try {
                            vt.getQuery().getRecord(vt.getSelectedRow());
                            String databaseName = vt.getQuery().fieldByName("table_schema").getString();
                            String tableName = vt.getQuery().fieldByName("table_name").getString();
                            if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)TruncateTableAction.this.stringManager.getString("deleting"), (String)TruncateTableAction.this.stringManager.getString("TruncateTableAction-truncate-table-q"), (int[])ModalResult.YESNO, (int)3) == 5) {
                                TruncateTableAction.this.getDatabase().executeCommand("TRUNCATE TABLE " + SQLUtil.createSqlName((String)databaseName, (String)tableName, (Database)TruncateTableAction.this.getDatabase()));
                                ip.refresh(null);
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.show((String)TruncateTableAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                        }
                    }
                }
            }
        };
    }

    public boolean isToolButton() {
        return false;
    }
}

