/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.cm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.gui.freezing.FreezeFactory;
import pl.mpak.orbada.mysql.gui.freezing.FreezeViewService;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ViewFreezeAction
extends ComponentAction {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public ViewFreezeAction() {
        this.setText(this.stringManager.getString("FreezeAction-description"));
        this.setTooltip(this.stringManager.getString("FreezeAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/freeze.gif"));
        this.setShortCut(114, 0);
        this.setActionCommandKey("FreezeAction");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTable vt;
                if (ViewFreezeAction.this.getComponent() instanceof ViewTable && (vt = (ViewTable)ViewFreezeAction.this.getComponent()).getSelectedRow() >= 0) {
                    PerspectivePanel panel = (PerspectivePanel)SwingUtil.getOwnerComponent(PerspectivePanel.class, (Component)ViewFreezeAction.this.getComponent());
                    IViewAccesibilities accesibilities = panel.getViewAccesibilitiesForChild(ViewFreezeAction.this.getComponent());
                    FreezeFactory freezeFactory = new FreezeFactory(accesibilities);
                    try {
                        vt.getQuery().getRecord(vt.getSelectedRow());
                        String databaseName = vt.getQuery().fieldByName("table_schema").getString();
                        String objectName = vt.getQuery().fieldByName("table_name").getString();
                        FreezeViewService service = freezeFactory.createInstance("VIEW", databaseName, objectName);
                        if (service != null) {
                            accesibilities.createView((ViewProvider)service);
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)ViewFreezeAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }

    public boolean isToolButton() {
        return true;
    }
}

