/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class AutotracePanel
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private Database database;
    private HashMap<String, String> sessionMap;
    private ArrayList<String[]> globalList;
    private ArrayList<String[]> sessionList;
    private ArrayList<String[]> diffList;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private Table tableGlobal;
    private Table tableLastSql;
    private Table tableSession;

    public AutotracePanel(Database database) {
        this.database = database;
        this.sessionMap = new HashMap();
        this.sessionList = new ArrayList();
        this.globalList = new ArrayList();
        this.diffList = new ArrayList();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableLastSql.setSelectionMode(0);
        this.tableLastSql.setModel((TableModel)new AbstractTableModel(){

            public String getColumnName(int column) {
                if (column == 0) {
                    return AutotracePanel.this.stringManager.getString("name");
                }
                if (column == 1) {
                    return AutotracePanel.this.stringManager.getString("value");
                }
                return "???";
            }

            public int getRowCount() {
                return AutotracePanel.this.diffList.size();
            }

            public int getColumnCount() {
                return 2;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                return ((String[])AutotracePanel.this.diffList.get(rowIndex))[columnIndex];
            }
        });
        this.tableSession.setSelectionMode(0);
        this.tableSession.setModel((TableModel)new AbstractTableModel(){

            public String getColumnName(int column) {
                if (column == 0) {
                    return AutotracePanel.this.stringManager.getString("name");
                }
                if (column == 1) {
                    return AutotracePanel.this.stringManager.getString("value");
                }
                return "???";
            }

            public int getRowCount() {
                return AutotracePanel.this.sessionList.size();
            }

            public int getColumnCount() {
                return 2;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                return ((String[])AutotracePanel.this.sessionList.get(rowIndex))[columnIndex];
            }
        });
        this.tableGlobal.setSelectionMode(0);
        this.tableGlobal.setModel((TableModel)new AbstractTableModel(){

            public String getColumnName(int column) {
                if (column == 0) {
                    return AutotracePanel.this.stringManager.getString("name");
                }
                if (column == 1) {
                    return AutotracePanel.this.stringManager.getString("value");
                }
                return "???";
            }

            public int getRowCount() {
                return AutotracePanel.this.globalList.size();
            }

            public int getColumnCount() {
                return 2;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                return ((String[])AutotracePanel.this.globalList.get(rowIndex))[columnIndex];
            }
        });
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeSql() {
        this.diffList.clear();
        this.sessionList.clear();
        Query query = this.database.createQuery();
        try {
            query.open(Sql.getStatsList());
            while (!query.eof()) {
                this.sessionMap.put(query.fieldByName("variable_name").getString(), query.fieldByName("variable_value").getString());
                this.sessionList.add(new String[]{query.fieldByName("variable_name").getString(), query.fieldByName("variable_value").getString()});
                query.next();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        this.tableLastSql.revalidate();
        this.tableSession.revalidate();
        this.tableGlobal.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterSql() {
        Query query = this.database.createQuery();
        try {
            query.open(Sql.getStatsList());
            while (!query.eof()) {
                String value = this.sessionMap.get(query.fieldByName("variable_name").getString());
                if (value != null && !value.equals(query.fieldByName("variable_value").getString())) {
                    try {
                        value = String.valueOf(query.fieldByName("variable_value").getLong() - Long.parseLong(value));
                    }
                    catch (NumberFormatException e) {
                        value = query.fieldByName("variable_value").getString();
                    }
                    this.diffList.add(new String[]{query.fieldByName("variable_name").getString(), value});
                }
                this.sessionMap.put(query.fieldByName("variable_name").getString(), query.fieldByName("variable_value").getString());
                this.sessionList.add(new String[]{query.fieldByName("variable_name").getString(), query.fieldByName("variable_value").getString()});
                query.next();
            }
            query.open(Sql.getGlobalStatsList());
            while (!query.eof()) {
                this.globalList.add(new String[]{query.fieldByName("variable_name").getString(), query.fieldByName("variable_value").getString()});
                query.next();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        this.tableLastSql.revalidate();
        this.tableSession.revalidate();
        this.tableGlobal.revalidate();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.tableLastSql = new Table();
        this.jScrollPane2 = new JScrollPane();
        this.tableSession = new Table();
        this.jScrollPane3 = new JScrollPane();
        this.tableGlobal = new Table();
        this.setLayout(new BorderLayout());
        this.jTabbedPane1.setFocusable(false);
        this.tableLastSql.setAutoResizeMode(4);
        this.jScrollPane1.setViewportView((Component)this.tableLastSql);
        this.jTabbedPane1.addTab(this.stringManager.getString("sql-command"), this.jScrollPane1);
        this.tableSession.setAutoResizeMode(4);
        this.jScrollPane2.setViewportView((Component)this.tableSession);
        this.jTabbedPane1.addTab(this.stringManager.getString("session-status"), this.jScrollPane2);
        this.tableGlobal.setAutoResizeMode(4);
        this.jScrollPane3.setViewportView((Component)this.tableGlobal);
        this.jTabbedPane1.addTab(this.stringManager.getString("global-status"), this.jScrollPane3);
        this.add((Component)this.jTabbedPane1, "Center");
    }
}

